/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.test;

import f00f.net.irc.martyr.GenericCommandAutoService;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.commands.MessageCommand;
import f00f.net.irc.martyr.dcc.AutoDccSetup;
import f00f.net.irc.martyr.dcc.ChatRequestCommand;
import f00f.net.irc.martyr.dcc.DccChatHandler;
import f00f.net.irc.martyr.dcc.DccSendHandler;
import f00f.net.irc.martyr.dcc.DccType;
import f00f.net.irc.martyr.services.AutoJoin;
import f00f.net.irc.martyr.services.AutoRegister;
import f00f.net.irc.martyr.services.AutoResponder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public class DccTestBot {
    static Logger log = Logger.getLogger(DccTestBot.class);
    private IRCConnection connection = new IRCConnection();

    public DccTestBot(String nick) {
        AutoRegister autoReg = new AutoRegister(this.connection, nick, "foo_user", "foo_name");
        AutoResponder autoRes = new AutoResponder(this.connection);
        AutoJoin autoJoin = new AutoJoin(this.connection, "#martyr");
        AutoDccTestSetup dccS = new AutoDccTestSetup(this.connection);
        new MessageMonitor(this.connection);
    }

    public void connect(String server, int port) throws IOException {
        this.connection.connect(server, port);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Requires nick, server, port");
            System.exit(1);
        }
        log.info((Object)"Starting test");
        DccTestBot bot = new DccTestBot(args[0]);
        log.info((Object)"Connecting");
        bot.connect(args[1], Integer.parseInt(args[2]));
    }

    static class AutoDccTestSetup
    extends AutoDccSetup {
        public AutoDccTestSetup(IRCConnection conn) {
            super(conn);
        }

        protected boolean authorizeConnect(DccType type, String argument, InetAddress netaddr, int port, int filesize) {
            return true;
        }

        protected DccSendHandler getDccSendHandler(Socket socket, String filename, int size) {
            return new TestSendHandler(socket, filename, size);
        }

        protected DccChatHandler getDccChatHandler(Socket socket) {
            return new TestChatHandler(socket);
        }
    }

    private static class MessageMonitor
    extends GenericCommandAutoService {
        public MessageMonitor(IRCConnection connection) {
            super(connection);
        }

        public void updateCommand(InCommand command) {
            MessageCommand mc;
            if (command instanceof MessageCommand && (mc = (MessageCommand)command).isPrivateToUs(this.connection.getClientState())) {
                this.handleCommand(mc);
            }
        }

        protected void handleCommand(MessageCommand mc) {
            if (mc.getMessage().equals("talk")) {
                try {
                    ChatRequestCommand out = new ChatRequestCommand(this.connection, mc.getSource().getNick(), new TestChatHandler());
                    this.connection.sendCommand(out);
                }
                catch (IOException ioe) {
                    log.error((Object)"Can't form connection");
                    ioe.printStackTrace();
                }
            } else {
                log.debug((Object)("Unknown command: " + mc.getMessage()));
            }
        }
    }

    static class TestChatHandler
    extends DccChatHandler {
        public TestChatHandler(Socket socket) {
            super(socket);
        }

        public TestChatHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDccChat(Socket socket) throws IOException {
            log.debug((Object)"Handling DCC chat");
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
                this.doChat(br, pw);
                socket.close();
            }
            finally {
                log.debug((Object)"Terminated DCC chat");
            }
        }

        protected void doChat(BufferedReader in, PrintWriter out) throws IOException {
            String rline;
            while ((rline = in.readLine()) != null) {
                out.print(rline + "\n");
                out.flush();
            }
        }

        public String toString() {
            return "TestChatHandler";
        }
    }

    static class TestSendHandler
    extends DccSendHandler {
        public TestSendHandler(Socket socket, String filename, int size) {
            super(socket, filename, size);
        }

        protected OutputStream getStreamForReceive(String filename, int size) throws IOException {
            File file = new File(filename);
            boolean b = file.createNewFile();
            if (!b) {
                return null;
            }
            return new FileOutputStream(file);
        }
    }
}

