/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.beans;

import java.nio.ByteBuffer;
import net.sf.jqql.Util;

public class ContactInfo {
    public static final String DIVIDER = Character.toString('\u001e');
    private static final int QQ_NUM = 0;
    private static final int NICK = 1;
    private static final int COUNTRY = 2;
    private static final int PROVINCE = 3;
    private static final int ZIPCODE = 4;
    private static final int ADDRESS = 5;
    private static final int TELEPHONE = 6;
    private static final int AGE = 7;
    private static final int GENDER = 8;
    private static final int NAME = 9;
    private static final int EMAIL = 10;
    private static final int PAGER_SN = 11;
    private static final int PAGER = 12;
    private static final int PAGER_SP = 13;
    private static final int PAGER_BASE_NUM = 14;
    private static final int PAGER_TYPE = 15;
    private static final int OCCUPATION = 16;
    private static final int HOMEPAGE = 17;
    private static final int AUTH_TYPE = 18;
    private static final int UNKNOWN_1 = 19;
    private static final int UNKNOWN_2 = 20;
    private static final int HEAD = 21;
    private static final int MOBILE = 22;
    private static final int MOBILE_TYPE = 23;
    private static final int INTRO = 24;
    private static final int CITY = 25;
    private static final int UNKNOWN_3 = 26;
    private static final int UNKNOWN_4 = 27;
    private static final int UNKNOWN_5 = 28;
    private static final int OPEN_HP = 29;
    private static final int OPEN_CONTACT = 30;
    private static final int COLLEGE = 31;
    private static final int HOROSCOPE = 32;
    private static final int ZODIAC = 33;
    private static final int BLODD = 34;
    private static final int USER_FLAG = 35;
    private static final int UNKNOWN_6 = 36;
    public int qq;
    public String nick;
    public String country;
    public String province;
    public String zipcode;
    public String address;
    public String telephone;
    public int age;
    public String gender;
    public String name;
    public String email;
    public String occupation;
    public String homepage;
    public int authType;
    public int head;
    public String mobile;
    public String intro;
    public String city;
    public int openContact;
    public String college;
    public int horoscope;
    public int zodiac;
    public int blood;
    public int userFlag;
    public int fieldCount;
    private String[] infos;

    public ContactInfo() {
        this.nick = "";
        this.country = "";
        this.province = "";
        this.zipcode = "";
        this.address = "";
        this.telephone = "";
        this.name = "";
        this.email = "";
        this.occupation = "";
        this.homepage = "";
        this.mobile = "";
        this.intro = "";
        this.city = "";
        this.college = "";
        this.gender = "";
        this.authType = 1;
        this.openContact = 1;
        this.fieldCount = 37;
    }

    public ContactInfo(ByteBuffer byteBuffer) {
        String string = Util.getString(byteBuffer);
        this.infos = string.split(DIVIDER);
        this.fieldCount = this.infos.length;
        this.qq = Util.getInt(this.infos[0], 0);
        this.nick = Util.filterUnprintableCharacter(this.infos[1]);
        this.country = this.infos[2];
        this.province = this.infos[3];
        this.zipcode = this.infos[4];
        this.address = this.infos[5];
        this.telephone = this.infos[6];
        this.age = Util.getInt(this.infos[7], 0);
        this.gender = this.infos[8];
        this.name = this.infos[9];
        this.email = this.infos[10];
        this.occupation = this.infos[16];
        this.homepage = this.infos[17];
        this.authType = Util.getInt(this.infos[18], 1);
        this.head = Util.getInt(this.infos[21], 0);
        this.mobile = this.infos[22];
        this.intro = this.infos[24];
        this.city = this.infos[25];
        this.openContact = Util.getInt(this.infos[30], 1);
        this.college = this.infos[31];
        this.horoscope = Util.getInt(this.infos[32], 0);
        this.zodiac = Util.getInt(this.infos[33], 0);
        this.blood = Util.getInt(this.infos[34], 0);
        this.userFlag = Util.getInt(this.infos[35], 0);
    }

    public String[] getInfoArray() {
        if (this.infos == null) {
            this.createInfoArray();
        }
        return this.infos;
    }

    private void createInfoArray() {
        this.infos = new String[37];
        this.infos[0] = String.valueOf(this.qq);
        this.infos[1] = this.nick;
        this.infos[2] = this.country;
        this.infos[3] = this.province;
        this.infos[4] = this.zipcode;
        this.infos[5] = this.address;
        this.infos[6] = this.telephone;
        this.infos[7] = String.valueOf(this.age);
        this.infos[8] = this.gender;
        this.infos[9] = this.name;
        this.infos[10] = this.email;
        this.infos[11] = "";
        this.infos[12] = "";
        this.infos[13] = "";
        this.infos[14] = "";
        this.infos[15] = "";
        this.infos[16] = this.occupation;
        this.infos[17] = this.homepage;
        this.infos[18] = String.valueOf(this.authType);
        this.infos[19] = "";
        this.infos[20] = "";
        this.infos[21] = String.valueOf(this.head);
        this.infos[22] = this.mobile;
        this.infos[23] = "";
        this.infos[24] = this.intro;
        this.infos[25] = this.city;
        this.infos[26] = "";
        this.infos[27] = "";
        this.infos[28] = "";
        this.infos[29] = "";
        this.infos[30] = String.valueOf(this.openContact);
        this.infos[31] = this.college;
        this.infos[32] = String.valueOf(this.horoscope);
        this.infos[33] = String.valueOf(this.zodiac);
        this.infos[34] = String.valueOf(this.blood);
        this.infos[35] = String.valueOf(this.userFlag);
        this.infos[36] = "";
    }
}

