/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.Writable;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class RvProxyInitSendCmd
extends RvProxyCmd {
    private static final int TYPE_CAP = 1;
    private final String sn;
    private final long icbmMessageId;
    private final CapabilityBlock capabilityBlock;

    protected RvProxyInitSendCmd(RvProxyPacket header) {
        super(header);
        ByteBlock data = header.getCommandData();
        StringBlock snInfo = OscarTools.readScreenname(data);
        if (snInfo != null) {
            this.sn = snInfo.getString();
            ByteBlock rest = data.subBlock(snInfo.getTotalSize());
            this.icbmMessageId = BinaryTools.getLong((ByteBlock)rest, (int)0);
            ByteBlock tlvBlock = rest.subBlock(8);
            ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
            Tlv capTlv = chain.getFirstTlv(1);
            this.capabilityBlock = capTlv != null ? new CapabilityBlock(capTlv.getData()) : null;
        } else {
            this.sn = null;
            this.icbmMessageId = 0L;
            this.capabilityBlock = null;
        }
    }

    public RvProxyInitSendCmd(String sn, long icbmMessageId) {
        this(sn, icbmMessageId, null);
    }

    public RvProxyInitSendCmd(String sn, long icbmMessageId, CapabilityBlock block) {
        super(2);
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        this.sn = sn;
        this.icbmMessageId = icbmMessageId;
        this.capabilityBlock = block;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final long getIcbmMessageId() {
        return this.icbmMessageId;
    }

    public CapabilityBlock getCapabilityBlock() {
        return this.capabilityBlock;
    }

    public void writeCommandData(OutputStream out) throws IOException {
        if (this.sn != null) {
            OscarTools.writeScreenname(out, this.sn);
            BinaryTools.writeLong((OutputStream)out, (long)this.icbmMessageId);
            if (this.capabilityBlock != null) {
                new Tlv(1, (Writable)this.capabilityBlock.getBlock()).write(out);
            }
        }
    }

    public String toString() {
        return "RvProxyInitSendCmd: sn=" + this.sn + ", icbmMessageId=" + this.icbmMessageId;
    }
}

