/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.services;

import f00f.net.irc.martyr.GenericAutoService;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.TimerTaskCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.commands.InviteCommand;
import f00f.net.irc.martyr.commands.JoinCommand;
import f00f.net.irc.martyr.commands.KickCommand;
import f00f.net.irc.martyr.errors.GenericJoinError;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class AutoJoin
extends GenericAutoService {
    static Logger log = Logger.getLogger(AutoJoin.class);
    private String channel = null;
    private String key = null;
    private TimerTaskCommand joinTimerTask = null;
    private long joinTimerTaskDelay = 10000L;

    public AutoJoin(IRCConnection connection, String channel) {
        this(connection, channel, null);
    }

    public AutoJoin(IRCConnection connection, String channel, String key) {
        super(connection);
        this.channel = channel;
        this.key = key;
        this.enable();
        this.updateState(connection.getState());
    }

    protected void updateState(State state) {
        if (state == State.REGISTERED) {
            this.performJoin();
        }
    }

    protected void updateCommand(InCommand command_o) {
        if (command_o instanceof KickCommand) {
            KickCommand kickCommand = (KickCommand)command_o;
            if (kickCommand.kickedUs(this.getConnection().getClientState()) && Channel.areEqual(kickCommand.getChannel(), this.channel)) {
                this.performJoin();
            }
        } else if (command_o instanceof GenericJoinError) {
            GenericJoinError joinErr = (GenericJoinError)command_o;
            if (Channel.areEqual(joinErr.getChannel(), this.channel)) {
                log.debug((Object)("AutoJoin: Failed to join channel: " + joinErr.getComment()));
                this.scheduleJoin();
            }
        } else if (command_o instanceof InviteCommand) {
            InviteCommand invite = (InviteCommand)command_o;
            if (!this.getConnection().getClientState().isOnChannel(invite.getChannel())) {
                this.performJoin();
            }
        }
    }

    protected synchronized void performJoin() {
        this.setupJoin();
        this.sendJoinCommand();
    }

    protected void setupJoin() {
        if (this.joinTimerTask != null) {
            this.joinTimerTask.cancel();
            this.joinTimerTask = null;
        }
    }

    protected void sendJoinCommand() {
        this.getConnection().sendCommand(new JoinCommand(this.channel, this.key));
    }

    protected void scheduleJoin() {
        if (this.joinTimerTask == null || !this.joinTimerTask.isScheduled()) {
            this.joinTimerTask = new TimerTaskCommand(this.getConnection(), new JoinCommand(this.channel, this.key));
            this.getConnection().getCronManager().schedule((TimerTask)this.joinTimerTask, this.joinTimerTaskDelay);
        }
    }

    public String toString() {
        if (this.key == null) {
            return "AutoJoin [" + this.channel + "]";
        }
        return "AutoJoin [" + this.channel + "," + this.key + "]";
    }
}

