/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.io.InputStream;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcValue;

public abstract class XmlRpcParser
extends DefaultHandler {
    public static final int VALUE = 111972721;
    public static final int STRING = -891985903;
    public static final int I4 = 3307;
    public static final int INT = 104431;
    public static final int BOOLEAN = 64711720;
    public static final int DOUBLE = -1325958191;
    public static final int DATE = -586971087;
    public static final int BASE64 = -1396204209;
    public static final int STRUCT = -891974699;
    public static final int ARRAY = 93090393;
    public static final int MEMBER = -1077769574;
    public static final int NAME = 3373707;
    private Stack values = new Stack();
    private XmlRpcValue currentValue;
    private boolean shallProcessCharData;
    private StringBuffer charData = new StringBuffer(128);
    private static Stack readers = new Stack();

    protected abstract void handleParsedValue(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream) throws XmlRpcException {
        XMLReader xMLReader = null;
        Stack stack = readers;
        synchronized (stack) {
            if (readers.empty()) {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException sAXException) {
                    throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcParser.ReaderInstantiationError"), sAXException);
                }
            } else {
                xMLReader = (XMLReader)readers.pop();
            }
        }
        xMLReader.setContentHandler(this);
        try {
            try {
                xMLReader.parse(new InputSource(inputStream));
            }
            catch (Exception exception) {
                throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcParser.ParsingError"), exception);
            }
        }
        finally {
            readers.push(xMLReader);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n = this.hashCode(string2);
        switch (n) {
            case 111972721: {
                if (this.currentValue != null) {
                    this.values.push(this.currentValue);
                }
                this.currentValue = new XmlRpcValue();
                this.shallProcessCharData = true;
                break;
            }
            case -1396204209: 
            case -1325958191: 
            case -891985903: 
            case -891974699: 
            case -586971087: 
            case 3307: 
            case 104431: 
            case 64711720: 
            case 93090393: {
                this.currentValue.setType(n);
            }
            case 3373707: {
                this.shallProcessCharData = true;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentValue != null && this.shallProcessCharData) {
            this.currentValue.processCharacterData(this.consumeCharData());
        } else {
            this.charData.setLength(0);
        }
        switch (this.hashCode(string2)) {
            case 111972721: {
                int n = this.values.size();
                if (n == 0) {
                    this.handleParsedValue(this.currentValue.value);
                    this.currentValue = null;
                    break;
                }
                if (this.values.elementAt(n - 1).hashCode() == -891974699) break;
                XmlRpcValue xmlRpcValue = this.currentValue;
                this.currentValue = (XmlRpcValue)this.values.pop();
                this.currentValue.addChildValue(xmlRpcValue);
                break;
            }
            case -1077769574: {
                XmlRpcValue xmlRpcValue = this.currentValue;
                this.currentValue = (XmlRpcValue)this.values.pop();
                this.currentValue.addChildValue(xmlRpcValue);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.charData.append(cArray, n, n2);
    }

    protected String consumeCharData() {
        String string = this.charData.toString().trim();
        this.charData.setLength(0);
        this.shallProcessCharData = false;
        return string;
    }

    private int hashCode(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + string.charAt(i);
        }
        return n;
    }
}

