/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.audiolevel;

import javax.media.Buffer;
import org.jitsi.impl.neomedia.audiolevel.AudioLevelCalculator;
import org.jitsi.impl.neomedia.audiolevel.AudioLevelMap;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;

public class AudioLevelEventDispatcher {
    private static final long IDLE_TIMEOUT = 30000L;
    private AudioLevelMap cache = null;
    private byte[] data = null;
    private int dataLength = 0;
    private SimpleAudioLevelListener listener;
    private long ssrc = -1L;
    private Thread thread;
    private final String threadName;

    public AudioLevelEventDispatcher(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        long idleTimeoutStart = -1L;
        while (true) {
            int dataLength;
            byte[] data;
            long ssrc;
            AudioLevelMap cache;
            SimpleAudioLevelListener listener;
            AudioLevelEventDispatcher audioLevelEventDispatcher = this;
            synchronized (audioLevelEventDispatcher) {
                if (!Thread.currentThread().equals(this.thread)) {
                    break;
                }
                listener = this.listener;
                cache = this.cache;
                ssrc = this.ssrc;
                if (listener == null && (cache == null || ssrc == -1L)) {
                    break;
                }
                data = this.data;
                dataLength = this.dataLength;
                if (data == null || dataLength < 1) {
                    if (idleTimeoutStart == -1L) {
                        idleTimeoutStart = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - idleTimeoutStart >= 30000L) {
                        break;
                    }
                    boolean interrupted = false;
                    try {
                        this.wait(30000L);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                this.data = null;
                this.dataLength = 0;
                idleTimeoutStart = -1L;
            }
            int newLevel = AudioLevelCalculator.calculateSoundPressureLevel(data, 0, dataLength, 0, 127);
            AudioLevelEventDispatcher audioLevelEventDispatcher2 = this;
            synchronized (audioLevelEventDispatcher2) {
                if (this.data == null && this.listener == null && (this.cache == null || this.ssrc == -1L)) {
                    this.data = data;
                }
            }
            if (cache != null && ssrc != -1L) {
                cache.putLevel(ssrc, newLevel);
            }
            if (listener == null) continue;
            listener.audioLevelChanged(newLevel);
        }
    }

    public synchronized void addData(Buffer buffer) {
        if (this.listener == null && (this.cache == null || this.ssrc == -1L)) {
            return;
        }
        this.dataLength = buffer.getLength();
        if (this.dataLength > 0) {
            Object bufferData;
            if (this.data == null || this.data.length < this.dataLength) {
                this.data = new byte[this.dataLength];
            }
            if ((bufferData = buffer.getData()) != null) {
                System.arraycopy(bufferData, buffer.getOffset(), this.data, 0, this.dataLength);
            }
            if (this.thread == null) {
                this.startThread();
            } else {
                this.notify();
            }
        }
    }

    public synchronized void setAudioLevelListener(SimpleAudioLevelListener listener) {
        if (this.listener != listener) {
            this.listener = listener;
            this.startOrNotifyThread();
        }
    }

    public synchronized void setAudioLevelCache(AudioLevelMap cache, long ssrc) {
        if (this.cache != cache || this.ssrc != ssrc) {
            this.cache = cache;
            this.ssrc = ssrc;
            this.startOrNotifyThread();
        }
    }

    private synchronized void startOrNotifyThread() {
        if (this.listener == null && (this.cache == null || this.ssrc == -1L)) {
            this.thread = null;
            this.notify();
        } else if (this.data != null && this.dataLength > 0) {
            if (this.thread == null) {
                this.startThread();
            } else {
                this.notify();
            }
        }
    }

    private synchronized void startThread() {
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AudioLevelEventDispatcher.this.run();
                }
                finally {
                    AudioLevelEventDispatcher audioLevelEventDispatcher = AudioLevelEventDispatcher.this;
                    synchronized (audioLevelEventDispatcher) {
                        if (Thread.currentThread().equals(AudioLevelEventDispatcher.this.thread)) {
                            AudioLevelEventDispatcher.this.thread = null;
                        }
                        if (AudioLevelEventDispatcher.this.thread == null && (AudioLevelEventDispatcher.this.listener != null || AudioLevelEventDispatcher.this.cache != null && AudioLevelEventDispatcher.this.ssrc != -1L) && AudioLevelEventDispatcher.this.data != null && AudioLevelEventDispatcher.this.dataLength > 0) {
                            AudioLevelEventDispatcher.this.startThread();
                        }
                    }
                }
            }
        };
        this.thread.setDaemon(true);
        if (this.threadName != null) {
            this.thread.setName(this.threadName);
        }
        this.thread.start();
    }
}

