/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.event.AccountManagerEvent;
import net.java.sip.communicator.service.protocol.event.AccountManagerListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class AccountManagerUtils {
    private static AccountManager getAccountManager(BundleContext bundleContext) {
        return (AccountManager)bundleContext.getService(bundleContext.getServiceReference(AccountManager.class.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void startBundleAndWaitStoredAccountsLoaded(BundleContext bundleContextWithAccountManager, final Bundle bundleToStart, final String protocolNameToWait) throws BundleException, InterruptedException {
        AccountManager accountManager = AccountManagerUtils.getAccountManager(bundleContextWithAccountManager);
        final boolean[] storedAccountsAreLoaded = new boolean[1];
        AccountManagerListener listener = new AccountManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleAccountManagerEvent(AccountManagerEvent event) {
                if (1 != event.getType()) {
                    return;
                }
                ProtocolProviderFactory factory = event.getFactory();
                if (factory != null && !protocolNameToWait.equals(factory.getProtocolName())) {
                    return;
                }
                if (factory != null) {
                    ServiceReference[] factoryRefs;
                    BundleContext bundleContext = bundleToStart.getBundleContext();
                    if (bundleContext == null) {
                        return;
                    }
                    try {
                        factoryRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), "(PROTOCOL_NAME=" + protocolNameToWait + ")");
                    }
                    catch (InvalidSyntaxException isex) {
                        factoryRefs = null;
                    }
                    if (factoryRefs != null) {
                        boolean factoryIsRegistered = false;
                        for (ServiceReference factoryRef : factoryRefs) {
                            if (factory != bundleContext.getService(factoryRef)) continue;
                            factoryIsRegistered = true;
                            break;
                        }
                        if (!factoryIsRegistered) {
                            return;
                        }
                    }
                }
                boolean[] blArray = storedAccountsAreLoaded;
                synchronized (storedAccountsAreLoaded) {
                    storedAccountsAreLoaded[0] = true;
                    storedAccountsAreLoaded.notify();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        accountManager.addListener(listener);
        try {
            bundleToStart.start();
            while (true) {
                boolean[] blArray = storedAccountsAreLoaded;
                // MONITORENTER : storedAccountsAreLoaded
                if (storedAccountsAreLoaded[0]) {
                    // MONITOREXIT : blArray
                    return;
                }
                storedAccountsAreLoaded.wait();
                // MONITOREXIT : blArray
            }
        }
        finally {
            accountManager.removeListener(listener);
        }
    }

    private AccountManagerUtils() {
    }
}

