/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.geolocation.GeolocationJabberUtils;
import net.java.sip.communicator.impl.protocol.jabber.extensions.geolocation.GeolocationPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.geolocation.GeolocationPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.geolocation.GeolocationPresence;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetGeolocation;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.GeolocationEvent;
import net.java.sip.communicator.service.protocol.event.GeolocationListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;

public class OperationSetGeolocationJabberImpl
implements OperationSetGeolocation {
    private static final Logger logger = Logger.getLogger(OperationSetGeolocationJabberImpl.class);
    private final List<GeolocationListener> geolocationContactsListeners = new Vector<GeolocationListener>();
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private final OperationSetPersistentPresence opsetprez;

    public OperationSetGeolocationJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.jabberProvider = provider;
        this.opsetprez = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
        this.jabberProvider.addRegistrationStateChangeListener(new RegistrationStateListener());
        ProviderManager pManager = ProviderManager.getInstance();
        pManager.addExtensionProvider("geoloc", "http://jabber.org/protocol/geoloc", (Object)new GeolocationPacketExtensionProvider());
    }

    public void publishGeolocation(Map<String, String> geolocation) {
        GeolocationPresence myGeolocPrez = new GeolocationPresence((OperationSetPresence)this.opsetprez);
        GeolocationPacketExtension geolocExt = GeolocationJabberUtils.convertMapToExtension(geolocation);
        myGeolocPrez.setGeolocationExtention(geolocExt);
        this.jabberProvider.getConnection().sendPacket((Packet)myGeolocPrez.getGeolocPresence());
    }

    public Map<String, String> queryContactGeolocation(String contactIdentifier) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGeolocationListener(GeolocationListener listener) {
        List<GeolocationListener> list = this.geolocationContactsListeners;
        synchronized (list) {
            this.geolocationContactsListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeolocationListener(GeolocationListener listener) {
        List<GeolocationListener> list = this.geolocationContactsListeners;
        synchronized (list) {
            this.geolocationContactsListeners.remove(listener);
        }
    }

    private class GeolocationPresencePacketListener
    implements PacketListener {
        private GeolocationPresencePacketListener() {
        }

        public void processPacket(Packet packet) {
            String from = StringUtils.parseBareAddress((String)packet.getFrom());
            GeolocationPacketExtension geolocExt = (GeolocationPacketExtension)packet.getExtension("geoloc", "http://jabber.org/protocol/geoloc");
            if (geolocExt != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("GeolocationExtension found from " + from + ":" + geolocExt.toXML()));
                }
                Map<String, String> newGeolocation = GeolocationJabberUtils.convertExtensionToMap(geolocExt);
                this.fireGeolocationContactChangeEvent(from, newGeolocation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireGeolocationContactChangeEvent(String sourceContact, Map<String, String> newGeolocation) {
            GeolocationListener[] listeners;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to dispatch geolocation contact update for " + sourceContact));
            }
            Contact source = OperationSetGeolocationJabberImpl.this.opsetprez.findContactByID(sourceContact);
            GeolocationEvent evt = new GeolocationEvent(source, (ProtocolProviderService)OperationSetGeolocationJabberImpl.this.jabberProvider, newGeolocation, (OperationSetGeolocation)OperationSetGeolocationJabberImpl.this);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dispatching  geolocation contact update. Listeners=" + OperationSetGeolocationJabberImpl.this.geolocationContactsListeners.size() + " evt=" + evt));
            }
            List list = OperationSetGeolocationJabberImpl.this.geolocationContactsListeners;
            synchronized (list) {
                listeners = OperationSetGeolocationJabberImpl.this.geolocationContactsListeners.toArray(new GeolocationListener[OperationSetGeolocationJabberImpl.this.geolocationContactsListeners.size()]);
            }
            for (GeolocationListener listener : listeners) {
                listener.contactGeolocationChanged(evt);
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The Jabber provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                PacketExtensionFilter filterGeoloc = new PacketExtensionFilter("geoloc", "http://jabber.org/protocol/geoloc");
                try {
                    OperationSetGeolocationJabberImpl.this.jabberProvider.getConnection().addPacketListener((PacketListener)new GeolocationPresencePacketListener(), (PacketFilter)filterGeoloc);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                // empty if block
            }
        }
    }
}

