/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Random;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;

public class ReconnectionManager
implements ConnectionListener {
    private Connection connection;
    private Thread reconnectionThread;
    private int randomBase = new Random().nextInt(11) + 5;
    boolean done = false;

    private ReconnectionManager(Connection connection) {
        this.connection = connection;
    }

    private boolean isReconnectionAllowed() {
        return !this.done && !this.connection.isConnected() && this.connection.isReconnectionAllowed();
    }

    protected synchronized void reconnect() {
        if (this.isReconnectionAllowed()) {
            if (this.reconnectionThread != null && this.reconnectionThread.isAlive()) {
                return;
            }
            this.reconnectionThread = new Thread(){
                private int attempts = 0;

                private int timeDelay() {
                    ++this.attempts;
                    if (this.attempts > 13) {
                        return ReconnectionManager.this.randomBase * 6 * 5;
                    }
                    if (this.attempts > 7) {
                        return ReconnectionManager.this.randomBase * 6;
                    }
                    return ReconnectionManager.this.randomBase;
                }

                @Override
                public void run() {
                    while (ReconnectionManager.this.isReconnectionAllowed()) {
                        int remainingSeconds = this.timeDelay();
                        while (ReconnectionManager.this.isReconnectionAllowed() && remainingSeconds > 0) {
                            try {
                                Thread.sleep(1000L);
                                ReconnectionManager.this.notifyAttemptToReconnectIn(--remainingSeconds);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                                ReconnectionManager.this.notifyReconnectionFailed(e1);
                            }
                        }
                        try {
                            if (!ReconnectionManager.this.isReconnectionAllowed()) continue;
                            ReconnectionManager.this.connection.connect();
                        }
                        catch (XMPPException e) {
                            ReconnectionManager.this.notifyReconnectionFailed(e);
                        }
                    }
                }
            };
            this.reconnectionThread.setName("Smack Reconnection Manager");
            this.reconnectionThread.setDaemon(true);
            this.reconnectionThread.start();
        }
    }

    protected void notifyReconnectionFailed(Exception exception) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener listener : this.connection.connectionListeners) {
                listener.reconnectionFailed(exception);
            }
        }
    }

    protected void notifyAttemptToReconnectIn(int seconds) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener listener : this.connection.connectionListeners) {
                listener.reconnectingIn(seconds);
            }
        }
    }

    @Override
    public void connectionClosed() {
        this.done = true;
    }

    @Override
    public void connectionClosedOnError(Exception e) {
        String reason;
        XMPPException xmppEx;
        StreamError error;
        this.done = false;
        if (e instanceof XMPPException && (error = (xmppEx = (XMPPException)e).getStreamError()) != null && "conflict".equals(reason = error.getCode())) {
            return;
        }
        if (this.isReconnectionAllowed()) {
            this.reconnect();
        }
    }

    @Override
    public void reconnectingIn(int seconds) {
    }

    @Override
    public void reconnectionFailed(Exception e) {
    }

    @Override
    public void reconnectionSuccessful() {
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                connection.addConnectionListener(new ReconnectionManager(connection));
            }
        });
    }
}

