/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.util.Iterator;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class PacketError {
    private static DocumentFactory docFactory = DocumentFactory.getInstance();
    private Element element;

    public PacketError(Condition condition) {
        this.element = docFactory.createElement("error");
        this.setCondition(condition);
        this.setType(condition.getDefaultType());
    }

    public PacketError(Condition condition, Type type) {
        this.element = docFactory.createElement("error");
        this.setCondition(condition);
        this.setType(type);
    }

    public PacketError(Type type, Condition condition, String text) {
        this.element = docFactory.createElement("error");
        this.setType(type);
        this.setCondition(condition);
        this.setText(text);
    }

    public PacketError(Element element) {
        this.element = element;
    }

    public Type getType() {
        String type = this.element.attributeValue("type");
        if (type != null) {
            return Type.fromXMPP(type);
        }
        return null;
    }

    public void setType(Type type) {
        this.element.addAttribute("type", type == null ? null : type.toXMPP());
    }

    public Condition getCondition() {
        Iterator i = this.element.elementIterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (!el.getNamespaceURI().equals("urn:ietf:params:xml:ns:xmpp-stanzas") || el.getName().equals("text")) continue;
            return Condition.fromXMPP(el.getName());
        }
        String code = this.element.attributeValue("code");
        if (code != null) {
            try {
                return Condition.fromLegacyCode(Integer.parseInt(code));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setCondition(Condition condition) {
        if (condition == null) {
            throw new NullPointerException("Condition cannot be null");
        }
        this.element.addAttribute("code", Integer.toString(condition.getLegacyCode()));
        Element conditionElement = null;
        Iterator i = this.element.elementIterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (!el.getNamespaceURI().equals("urn:ietf:params:xml:ns:xmpp-stanzas") || el.getName().equals("text")) continue;
            conditionElement = el;
        }
        if (conditionElement != null) {
            this.element.remove(conditionElement);
        }
        conditionElement = docFactory.createElement(condition.toXMPP(), "urn:ietf:params:xml:ns:xmpp-stanzas");
        this.element.add(conditionElement);
    }

    public String getText() {
        return this.element.elementText("text");
    }

    public void setText(String text) {
        Element textElement = this.element.element("text");
        if (text == null) {
            if (textElement != null) {
                this.element.remove(textElement);
            }
            return;
        }
        if (textElement == null) {
            textElement = docFactory.createElement("text", "urn:ietf:params:xml:ns:xmpp-stanzas");
            this.element.add(textElement);
        }
        textElement.setText(text);
    }

    public Element getElement() {
        return this.element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        cancel("cancel"),
        continue_processing("continue"),
        modify("modify"),
        auth("auth"),
        wait("wait");

        private String value;

        public static Type fromXMPP(String type) {
            if (type == null) {
                throw new NullPointerException();
            }
            type = type.toLowerCase();
            if (cancel.toXMPP().equals(type)) {
                return cancel;
            }
            if (continue_processing.toXMPP().equals(type)) {
                return continue_processing;
            }
            if (modify.toXMPP().equals(type)) {
                return modify;
            }
            if (auth.toXMPP().equals(type)) {
                return auth;
            }
            if (wait.toXMPP().equals(type)) {
                return wait;
            }
            throw new IllegalArgumentException("Type invalid:" + type);
        }

        private Type(String value) {
            this.value = value;
        }

        public String toXMPP() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Condition {
        bad_request("bad-request", Type.modify, 400),
        conflict("conflict", Type.cancel, 409),
        feature_not_implemented("feature-not-implemented", Type.cancel, 501),
        forbidden("forbidden", Type.auth, 403),
        gone("gone", Type.modify, 302),
        internal_server_error("internal-server-error", Type.wait, 500),
        item_not_found("item-not-found", Type.cancel, 404),
        jid_malformed("jid-malformed", Type.modify, 400),
        not_acceptable("not-acceptable", Type.modify, 406),
        not_allowed("not-allowed", Type.cancel, 405),
        not_authorized("not-authorized", Type.auth, 401),
        payment_required("payment-required", Type.auth, 402),
        recipient_unavailable("recipient-unavailable", Type.wait, 404),
        redirect("redirect", Type.modify, 302),
        registration_required("registration-required", Type.auth, 407),
        remote_server_not_found("remote-server-not-found", Type.cancel, 404),
        remote_server_timeout("remote-server-timeout", Type.wait, 504),
        resource_constraint("resource-constraint", Type.wait, 500),
        service_unavailable("service-unavailable", Type.cancel, 503),
        subscription_required("subscription-required", Type.auth, 407),
        undefined_condition("undefined-condition", Type.wait, 500),
        unexpected_condition("unexpected-condition", Type.wait, 400);

        private String value;
        private int code;
        private Type defaultType;

        public static Condition fromXMPP(String condition) {
            if (condition == null) {
                throw new NullPointerException();
            }
            condition = condition.toLowerCase();
            if (bad_request.toXMPP().equals(condition)) {
                return bad_request;
            }
            if (conflict.toXMPP().equals(condition)) {
                return conflict;
            }
            if (feature_not_implemented.toXMPP().equals(condition)) {
                return feature_not_implemented;
            }
            if (forbidden.toXMPP().equals(condition)) {
                return forbidden;
            }
            if (gone.toXMPP().equals(condition)) {
                return gone;
            }
            if (internal_server_error.toXMPP().equals(condition)) {
                return internal_server_error;
            }
            if (item_not_found.toXMPP().equals(condition)) {
                return item_not_found;
            }
            if (jid_malformed.toXMPP().equals(condition)) {
                return jid_malformed;
            }
            if (not_acceptable.toXMPP().equals(condition)) {
                return not_acceptable;
            }
            if (not_allowed.toXMPP().equals(condition)) {
                return not_allowed;
            }
            if (not_authorized.toXMPP().equals(condition)) {
                return not_authorized;
            }
            if (payment_required.toXMPP().equals(condition)) {
                return payment_required;
            }
            if (recipient_unavailable.toXMPP().equals(condition)) {
                return recipient_unavailable;
            }
            if (redirect.toXMPP().equals(condition)) {
                return redirect;
            }
            if (registration_required.toXMPP().equals(condition)) {
                return registration_required;
            }
            if (remote_server_not_found.toXMPP().equals(condition)) {
                return remote_server_not_found;
            }
            if (remote_server_timeout.toXMPP().equals(condition)) {
                return remote_server_timeout;
            }
            if (resource_constraint.toXMPP().equals(condition)) {
                return resource_constraint;
            }
            if (service_unavailable.toXMPP().equals(condition)) {
                return service_unavailable;
            }
            if (subscription_required.toXMPP().equals(condition)) {
                return subscription_required;
            }
            if (undefined_condition.toXMPP().equals(condition)) {
                return undefined_condition;
            }
            if (unexpected_condition.toXMPP().equals(condition)) {
                return unexpected_condition;
            }
            throw new IllegalArgumentException("Condition invalid:" + condition);
        }

        public static Condition fromLegacyCode(int code) {
            if (bad_request.getLegacyCode() == code) {
                return bad_request;
            }
            if (conflict.getLegacyCode() == code) {
                return conflict;
            }
            if (feature_not_implemented.getLegacyCode() == code) {
                return feature_not_implemented;
            }
            if (forbidden.getLegacyCode() == code) {
                return forbidden;
            }
            if (gone.getLegacyCode() == code) {
                return gone;
            }
            if (internal_server_error.getLegacyCode() == code) {
                return internal_server_error;
            }
            if (item_not_found.getLegacyCode() == code) {
                return item_not_found;
            }
            if (jid_malformed.getLegacyCode() == code) {
                return jid_malformed;
            }
            if (not_acceptable.getLegacyCode() == code) {
                return not_acceptable;
            }
            if (not_allowed.getLegacyCode() == code) {
                return not_allowed;
            }
            if (not_authorized.getLegacyCode() == code) {
                return not_authorized;
            }
            if (payment_required.getLegacyCode() == code) {
                return payment_required;
            }
            if (recipient_unavailable.getLegacyCode() == code) {
                return recipient_unavailable;
            }
            if (redirect.getLegacyCode() == code) {
                return redirect;
            }
            if (registration_required.getLegacyCode() == code) {
                return registration_required;
            }
            if (remote_server_not_found.getLegacyCode() == code) {
                return remote_server_not_found;
            }
            if (remote_server_timeout.getLegacyCode() == code) {
                return remote_server_timeout;
            }
            if (resource_constraint.getLegacyCode() == code) {
                return resource_constraint;
            }
            if (service_unavailable.getLegacyCode() == code) {
                return service_unavailable;
            }
            if (subscription_required.getLegacyCode() == code) {
                return subscription_required;
            }
            if (undefined_condition.getLegacyCode() == code) {
                return undefined_condition;
            }
            if (unexpected_condition.getLegacyCode() == code) {
                return unexpected_condition;
            }
            throw new IllegalArgumentException("Code invalid:" + code);
        }

        private Condition(String value, Type defaultType, int code) {
            this.value = value;
            this.defaultType = defaultType;
            this.code = code;
        }

        public Type getDefaultType() {
            return this.defaultType;
        }

        public int getLegacyCode() {
            return this.code;
        }

        public String toXMPP() {
            return this.value;
        }
    }
}

