/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import java.util.Objects;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NegotiatingServerConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.server.NPNServerConnectionFactory;
import org.eclipse.jetty.spdy.server.SPDYServerConnectionFactory;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.spdy.server.proxy.ProxyHTTPConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HTTPSPDYProxyServerConnector
extends ServerConnector {
    public HTTPSPDYProxyServerConnector(Server server, ProxyEngineSelector proxyEngineSelector) {
        this(server, new HttpConfiguration(), proxyEngineSelector);
    }

    public HTTPSPDYProxyServerConnector(Server server, HttpConfiguration config, ProxyEngineSelector proxyEngineSelector) {
        super(server, (SslContextFactory)null, new ConnectionFactory[]{new ProxyHTTPConnectionFactory(config, 2, proxyEngineSelector)});
    }

    public HTTPSPDYProxyServerConnector(Server server, SslContextFactory sslContextFactory, ProxyEngineSelector proxyEngineSelector) {
        this(server, sslContextFactory, new HttpConfiguration(), proxyEngineSelector);
    }

    public HTTPSPDYProxyServerConnector(Server server, SslContextFactory sslContextFactory, HttpConfiguration config, ProxyEngineSelector proxyEngineSelector) {
        this(server, sslContextFactory, config, proxyEngineSelector, (NegotiatingServerConnectionFactory)new NPNServerConnectionFactory(new String[]{"spdy/3", "spdy/2", "http/1.1"}));
    }

    public HTTPSPDYProxyServerConnector(Server server, SslContextFactory sslContextFactory, HttpConfiguration config, ProxyEngineSelector proxyEngineSelector, NegotiatingServerConnectionFactory negotiatingFactory) {
        super(server, Objects.requireNonNull(sslContextFactory), new ConnectionFactory[]{negotiatingFactory, new SPDYServerConnectionFactory(3, (ServerSessionFrameListener)proxyEngineSelector), new SPDYServerConnectionFactory(2, (ServerSessionFrameListener)proxyEngineSelector), new ProxyHTTPConnectionFactory(config, 2, proxyEngineSelector)});
        negotiatingFactory.setDefaultProtocol("http/1.1");
    }
}

