/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.plugins;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Enumeration;
import org.mockito.internal.configuration.plugins.DefaultMockitoPlugins;
import org.mockito.internal.configuration.plugins.PluginFinder;
import org.mockito.internal.util.collections.Iterables;
import org.mockito.plugins.PluginSwitch;

class PluginLoader {
    private final DefaultMockitoPlugins plugins = new DefaultMockitoPlugins();
    private final PluginSwitch pluginSwitch;
    private String alias;

    public PluginLoader(PluginSwitch pluginSwitch) {
        this.pluginSwitch = pluginSwitch;
    }

    @Deprecated
    PluginLoader withAlias(String name) {
        this.alias = name;
        return this;
    }

    <T> T loadPlugin(final Class<T> pluginType) {
        try {
            T plugin = this.loadImpl(pluginType);
            if (plugin != null) {
                return plugin;
            }
            return this.plugins.getDefaultPlugin(pluginType);
        }
        catch (Throwable t) {
            return (T)Proxy.newProxyInstance(pluginType.getClassLoader(), new Class[]{pluginType}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new IllegalStateException("Could not initialize plugin: " + pluginType, t);
                }
            });
        }
    }

    private <T> T loadImpl(Class<T> service) {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            resources = loader.getResources("mockito-extensions/" + service.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load " + service, e);
        }
        try {
            String classOrAlias = new PluginFinder(this.pluginSwitch).findPluginClass(Iterables.toIterable(resources));
            if (classOrAlias != null) {
                if (classOrAlias.equals(this.alias)) {
                    classOrAlias = this.plugins.getDefaultPluginClass(this.alias);
                }
                Class<?> pluginClass = loader.loadClass(classOrAlias);
                Object plugin = pluginClass.newInstance();
                return service.cast(plugin);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load " + service + " implementation declared in " + resources, e);
        }
    }
}

