/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.ext.jsr353.JSR353Bundle;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

class GensonJsonObject
extends AbstractMap<String, JsonValue>
implements JsonObject {
    private final Map<String, JsonValue> values;

    GensonJsonObject(Map<String, JsonValue> values) {
        this.values = values;
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.values.entrySet();
    }

    public JsonArray getJsonArray(String name) {
        return (JsonArray)JsonArray.class.cast(this.values.get(name));
    }

    public JsonObject getJsonObject(String name) {
        return (JsonObject)JsonObject.class.cast(this.values.get(name));
    }

    public JsonNumber getJsonNumber(String name) {
        return (JsonNumber)JsonNumber.class.cast(this.values.get(name));
    }

    public JsonString getJsonString(String name) {
        return (JsonString)JsonString.class.cast(this.values.get(name));
    }

    public String getString(String name) {
        return this.getJsonString(name).getString();
    }

    public String getString(String name, String defaultValue) {
        if (this.isNull(name)) {
            return defaultValue;
        }
        return this.getString(name);
    }

    public int getInt(String name) {
        return this.getJsonNumber(name).intValue();
    }

    public int getInt(String name, int defaultValue) {
        if (this.isNull(name)) {
            return defaultValue;
        }
        return this.getInt(name);
    }

    public boolean getBoolean(String name) {
        JsonValue value = this.values.get(name);
        if (JsonValue.TRUE.equals(value)) {
            return true;
        }
        if (JsonValue.FALSE.equals(value)) {
            return false;
        }
        throw new ClassCastException();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.isNull(name)) {
            return defaultValue;
        }
        return this.getBoolean(name);
    }

    public boolean isNull(String name) {
        JsonValue value = this.values.get(name);
        return JsonValue.NULL.equals(value) || value == null;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    @Override
    public String toString() {
        return JSR353Bundle.toString((JsonValue)this);
    }
}

