/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txncollection.operations;

import com.hazelcast.collection.impl.collection.CollectionContainer;
import com.hazelcast.collection.impl.collection.operations.CollectionOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public class CollectionPrepareBackupOperation
extends CollectionOperation
implements BackupOperation {
    private long itemId;
    private boolean removeOperation;
    private String transactionId;

    public CollectionPrepareBackupOperation() {
    }

    public CollectionPrepareBackupOperation(String name, long itemId, String transactionId, boolean removeOperation) {
        super(name);
        this.itemId = itemId;
        this.removeOperation = removeOperation;
        this.transactionId = transactionId;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer collectionContainer = this.getOrCreateContainer();
        if (this.removeOperation) {
            collectionContainer.reserveRemoveBackup(this.itemId, this.transactionId);
        } else {
            collectionContainer.reserveAddBackup(this.itemId, this.transactionId);
        }
    }

    @Override
    public int getId() {
        return 31;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.removeOperation);
        out.writeUTF(this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.removeOperation = in.readBoolean();
        this.transactionId = in.readUTF();
    }
}

