/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.processor;

import com.voxeo.processor.AProcessorItem;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Processor {
    private final ConcurrentLinkedQueue<AProcessorItem> queue = new ConcurrentLinkedQueue();
    private final String name;
    private boolean started = false;
    private boolean closed = false;

    public Processor(String name) {
        this.name = name;
    }

    public Processor(String name, int nrProcessorThreads) {
        this.name = name;
        this.init(nrProcessorThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int nrProcessorThreads) {
        if (this.started) {
            return;
        }
        this.started = true;
        for (int i = 0; i < nrProcessorThreads; ++i) {
            ProcessorThread processorThread = new ProcessorThread(this.name);
            processorThread.setDaemon(true);
            processorThread.start();
        }
        ConcurrentLinkedQueue<AProcessorItem> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AProcessorItem processorItem) {
        this.queue.add(processorItem);
        ConcurrentLinkedQueue<AProcessorItem> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            this.queue.notify();
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        ConcurrentLinkedQueue<AProcessorItem> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            this.queue.notify();
        }
    }

    class ProcessorThread
    extends Thread {
        public ProcessorThread(String name) {
            super(name + "ProcessorThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!Processor.this.closed) {
                    AProcessorItem processorQueueItem;
                    ConcurrentLinkedQueue concurrentLinkedQueue = Processor.this.queue;
                    synchronized (concurrentLinkedQueue) {
                        while (Processor.this.queue.isEmpty()) {
                            Processor.this.queue.wait();
                            if (!Processor.this.closed) continue;
                            return;
                        }
                        processorQueueItem = (AProcessorItem)Processor.this.queue.remove();
                    }
                    processorQueueItem.process();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

