/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import net.sf.jml.util.CharsetUtils;

public class Charset {
    private static final CharsetUtils charsetUtils = new CharsetUtils("UTF-8");

    public static ByteBuffer encode(CharBuffer charBuffer) {
        return charsetUtils.encode(charBuffer);
    }

    public static ByteBuffer encode(String string) {
        return charsetUtils.encode(string);
    }

    public static ByteBuffer[] encode(String string, int n) {
        return charsetUtils.encode(CharBuffer.wrap(string), n);
    }

    public static byte[] encodeAsByteArray(String string) {
        ByteBuffer byteBuffer = Charset.encode(string);
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static String decode(ByteBuffer byteBuffer) {
        return charsetUtils.decode(byteBuffer).toString();
    }

    public static String decode(byte[] byArray) {
        return Charset.decode(ByteBuffer.wrap(byArray));
    }

    public static String decode(byte[] byArray, int n, int n2) {
        return Charset.decode(ByteBuffer.wrap(byArray, n, n2));
    }
}

