/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.GGException;
import pl.mn.communicator.GGSessionException;
import pl.mn.communicator.ILocalStatus;
import pl.mn.communicator.ILoginService;
import pl.mn.communicator.IRemoteStatus;
import pl.mn.communicator.IUser;
import pl.mn.communicator.LocalStatus;
import pl.mn.communicator.LoginContext;
import pl.mn.communicator.Session;
import pl.mn.communicator.SessionState;
import pl.mn.communicator.StatusType;
import pl.mn.communicator.event.LoginFailedEvent;
import pl.mn.communicator.event.LoginListener;
import pl.mn.communicator.event.UserListener;
import pl.mn.communicator.packet.out.GGLogin60;

public class DefaultLoginService
implements ILoginService,
UserListener {
    private static final Log logger = LogFactory.getLog((Class)DefaultLoginService.class);
    private Session m_session = null;
    private Vector m_loginListeners = new Vector();
    private LoginContext m_loginContext = null;

    DefaultLoginService(Session session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.m_session = session;
    }

    public void login(LoginContext loginContext) throws GGException {
        logger.debug((Object)("Logging in, loginContext: " + loginContext));
        if (loginContext == null) {
            throw new NullPointerException("loginContext cannot be null");
        }
        this.m_loginContext = loginContext;
        if (this.m_session.getSessionState() != SessionState.AUTHENTICATION_AWAITING) {
            throw new GGSessionException(this.m_session.getSessionState());
        }
        this.m_session.getPresenceService().addUserListener(this);
        try {
            int uin = loginContext.getUin();
            String password = loginContext.getPassword();
            int seed = this.m_session.getSessionAccessor().getLoginSeed();
            GGLogin60 login = new GGLogin60(uin, password.toCharArray(), seed);
            login.setStatus(loginContext.getStatus());
            if (loginContext.getImageSize() != -1) {
                login.setImageSize(loginContext.getImageSize());
            }
            if (loginContext.getLocalIP() != null) {
                login.setLocalIP(loginContext.getLocalIP());
            }
            if (loginContext.getLocalPort() != -1) {
                login.setLocalPort(loginContext.getLocalPort());
            }
            if (loginContext.getExternalIP() != null) {
                login.setExternalIP(loginContext.getExternalIP());
            }
            if (loginContext.getExternalPort() != -1) {
                login.setExternalPort(loginContext.getExternalPort());
            }
            this.m_session.getSessionAccessor().sendPackage(login);
        }
        catch (IOException ex) {
            this.m_session.getSessionAccessor().setSessionState(SessionState.DISCONNECTED);
            throw new GGException("Unable to login, loginContext: " + loginContext, ex);
        }
    }

    public void logout() throws GGException {
        logger.debug((Object)("Logging out, loginContext: " + this.m_loginContext));
        this.logout(false, null, null, true);
    }

    public void logout(String description, Date returnTime) throws GGException {
        if (description == null) {
            description = "";
        }
        this.checkSessionState();
        this.logout(true, description, returnTime, true);
    }

    public LoginContext getLoginContext() {
        return this.m_loginContext;
    }

    public boolean isLoggedIn() {
        return this.m_session.getSessionState() == SessionState.LOGGED_IN;
    }

    public void addLoginListener(LoginListener loginListener) {
        if (loginListener == null) {
            throw new NullPointerException("loginListener cannot be null");
        }
        this.m_loginListeners.add(loginListener);
    }

    public void removeLoginListener(LoginListener loginListener) {
        if (loginListener == null) {
            throw new NullPointerException("loginListener cannot  be null");
        }
        this.m_loginListeners.remove(loginListener);
    }

    protected void notifyLoginOK() throws GGException {
        this.m_session.getSessionAccessor().setSessionState(SessionState.LOGGED_IN);
        Iterator it = this.m_loginListeners.iterator();
        while (it.hasNext()) {
            LoginListener loginListener = (LoginListener)it.next();
            loginListener.loginOK();
        }
    }

    protected void notifyLoginFailed(LoginFailedEvent loginFailedEvent) throws GGException {
        this.m_session.getSessionAccessor().setSessionState(SessionState.CONNECTION_ERROR);
        Iterator it = this.m_loginListeners.iterator();
        while (it.hasNext()) {
            LoginListener loginListener = (LoginListener)it.next();
            loginListener.loginFailed(loginFailedEvent);
        }
    }

    protected void notifyLoggedOut() throws GGException {
        Iterator it = this.m_loginListeners.iterator();
        while (it.hasNext()) {
            LoginListener loginListener = (LoginListener)it.next();
            loginListener.loggedOut();
        }
    }

    public void localStatusChanged(ILocalStatus localStatus) throws GGException {
        if (localStatus.getStatusType() == StatusType.OFFLINE) {
            this.logout(false, null, null, false);
        } else if (localStatus.getStatusType() == StatusType.OFFLINE_WITH_DESCRIPTION) {
            this.logout(true, localStatus.getDescription(), localStatus.getReturnDate(), false);
        }
    }

    public void userStatusChanged(IUser user, IRemoteStatus newStatus) throws GGException {
    }

    private void checkSessionState() throws GGException {
        if (this.m_session.getSessionState() != SessionState.LOGGED_IN) {
            throw new GGSessionException(this.m_session.getSessionState());
        }
    }

    private void logout(boolean offLineWithStatus, String description, Date returnDate, boolean sendStatus) throws GGException {
        this.checkSessionState();
        if (!offLineWithStatus) {
            if (sendStatus) {
                LocalStatus localStatus = new LocalStatus(StatusType.OFFLINE);
                this.m_session.getPresenceService().setStatus(localStatus);
            }
            this.m_session.getSessionAccessor().setSessionState(SessionState.LOGGED_OUT);
            this.m_loginContext = null;
            this.m_session.getSessionAccessor().notifyLoggedOut();
        } else {
            if (description == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            if (description.length() > 0) {
                if (sendStatus) {
                    LocalStatus localStatus = new LocalStatus(StatusType.OFFLINE_WITH_DESCRIPTION, description);
                    if (returnDate != null) {
                        localStatus.setReturnDate(returnDate);
                    }
                    this.m_session.getPresenceService().setStatus(localStatus);
                }
                this.m_loginContext = null;
                this.m_session.getSessionAccessor().setSessionState(SessionState.LOGGED_OUT);
                this.notifyLoggedOut();
            }
        }
    }
}

