/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.io.File;
import java.io.UnsupportedEncodingException;
import net.sf.jml.MsnContact;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnFileTransferImpl;
import net.sf.jml.message.p2p.FileTransferWorker;
import net.sf.jml.message.p2p.MsnFileContextParser;
import net.sf.jml.message.p2p.MsnP2PSlpMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.msnslp.MsnslpRequest;
import net.sf.jml.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MsnFileInviteMessage
extends MsnP2PSlpMessage {
    private static final Log logger = LogFactory.getLog(MsnFileInviteMessage.class);
    public static final String METHOD_INVITE = "INVITE";
    public static final String KEY_GUID_EUF = "EUF-GUID";
    public static final String KEY_CONTEXT = "Context";
    public static final String KEY_FROM = "From";
    public static final String GUID_EUF = "{5D3E02AB-6190-11D3-BBBB-00C04F795683}";

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        if (!(this.getSlpMessage() instanceof MsnslpRequest)) {
            logger.info((Object)("not a MsnslpRequest: " + this.getSlpMessage().getClass().getName()));
            return;
        }
        MsnslpRequest msnslpRequest = (MsnslpRequest)this.getSlpMessage();
        String string = msnslpRequest.getRequestMethod();
        String string2 = msnslpRequest.getBodys().getProperty(KEY_GUID_EUF);
        String string3 = msnslpRequest.getBodys().getProperty(KEY_CONTEXT);
        int n = this.getSlpMessage().getBodys().getIntProperty("SessionID", -1);
        String string4 = String.valueOf(n);
        if (string != null && string.equals(METHOD_INVITE) && msnslpRequest.getCSeq() == 0 && string2 != null && string2.equals(GUID_EUF) && string3 != null) {
            string3 = string3.substring(0, string3.length() - 1);
            byte[] byArray = Base64.decode(string3);
            long l = MsnFileContextParser.getFileSize(byArray, 8);
            String string5 = null;
            try {
                string5 = MsnFileContextParser.getFileName(byArray, 20);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)"Cannot extract fileName", (Throwable)unsupportedEncodingException);
                return;
            }
            MsnFileTransferImpl msnFileTransferImpl = new MsnFileTransferImpl(string4, msnContact.getEmail(), this, msnSession, false);
            msnFileTransferImpl.setContact(msnContact);
            msnFileTransferImpl.setFile(new File(string5));
            msnFileTransferImpl.setFileTotalSize(l);
            FileTransferWorker fileTransferWorker = new FileTransferWorker(msnFileTransferImpl);
            msnSession.getMessenger().getFileTransferManager().addFileTransfer(string4, fileTransferWorker);
            fileTransferWorker.sendP2PAck(this, false);
            ((AbstractMessenger)msnSession.getMessenger()).fireFileTransferRequestReceived(msnFileTransferImpl);
        } else {
            FileTransferWorker fileTransferWorker = msnSession.getMessenger().getFileTransferManager().getFileTransferWorker(string4);
            if (fileTransferWorker != null) {
                fileTransferWorker.sendDeny(this);
            }
        }
    }
}

