/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NodeIOService
implements IOService {
    private final Node node;
    private final NodeEngineImpl nodeEngine;

    public NodeIOService(Node node) {
        this.node = node;
        this.nodeEngine = node.nodeEngine;
    }

    @Override
    public boolean isActive() {
        return this.node.isActive();
    }

    @Override
    public ILogger getLogger(String name) {
        return this.node.getLogger(name);
    }

    @Override
    public void onOutOfMemory(OutOfMemoryError oom) {
        OutOfMemoryErrorDispatcher.onOutOfMemory(oom);
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public void onFatalError(Exception e) {
        new Thread(this.node.threadGroup, this.node.getThreadNamePrefix("io.error.shutdown")){

            @Override
            public void run() {
                NodeIOService.this.node.shutdown(false);
            }
        }.start();
    }

    @Override
    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.node.getConfig().getNetworkConfig().getSocketInterceptorConfig();
    }

    @Override
    public SymmetricEncryptionConfig getSymmetricEncryptionConfig() {
        return this.node.getConfig().getNetworkConfig().getSymmetricEncryptionConfig();
    }

    @Override
    public SSLConfig getSSLConfig() {
        return this.node.getConfig().getNetworkConfig().getSSLConfig();
    }

    @Override
    public void handleMemberPacket(Packet packet) {
        MemberImpl member;
        Address endPoint = packet.getConn().getEndPoint();
        if (endPoint != null && (member = this.node.clusterService.getMember(endPoint)) != null) {
            member.didRead();
        }
        this.nodeEngine.handlePacket(packet);
    }

    @Override
    public void handleClientPacket(Packet p) {
        this.node.clientEngine.handlePacket(p);
    }

    @Override
    public TextCommandService getTextCommandService() {
        return this.node.getTextCommandService();
    }

    @Override
    public boolean isMemcacheEnabled() {
        return this.node.groupProperties.MEMCACHE_ENABLED.getBoolean();
    }

    @Override
    public boolean isRestEnabled() {
        return this.node.groupProperties.REST_ENABLED.getBoolean();
    }

    @Override
    public void removeEndpoint(final Address endPoint) {
        this.nodeEngine.getExecutionService().execute("hz:io", new Runnable(){

            @Override
            public void run() {
                ((NodeIOService)NodeIOService.this).node.clusterService.removeAddress(endPoint);
            }
        });
    }

    @Override
    public String getThreadPrefix() {
        return this.node.getThreadPoolNamePrefix("IO");
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.node.threadGroup;
    }

    @Override
    public void onFailedConnection(Address address) {
        if (!this.node.joined()) {
            this.node.getJoiner().blacklist(address);
        }
    }

    @Override
    public void shouldConnectTo(Address address) {
        if (this.node.getThisAddress().equals(address)) {
            throw new RuntimeException("Connecting to self! " + address);
        }
    }

    @Override
    public boolean isSocketBind() {
        return this.node.groupProperties.SOCKET_CLIENT_BIND.getBoolean();
    }

    @Override
    public boolean isSocketBindAny() {
        return this.node.groupProperties.SOCKET_CLIENT_BIND_ANY.getBoolean();
    }

    @Override
    public int getSocketReceiveBufferSize() {
        return this.node.getGroupProperties().SOCKET_RECEIVE_BUFFER_SIZE.getInteger();
    }

    @Override
    public int getSocketSendBufferSize() {
        return this.node.getGroupProperties().SOCKET_SEND_BUFFER_SIZE.getInteger();
    }

    @Override
    public int getSocketLingerSeconds() {
        return this.node.getGroupProperties().SOCKET_LINGER_SECONDS.getInteger();
    }

    @Override
    public boolean getSocketKeepAlive() {
        return this.node.getGroupProperties().SOCKET_KEEP_ALIVE.getBoolean();
    }

    @Override
    public boolean getSocketNoDelay() {
        return this.node.getGroupProperties().SOCKET_NO_DELAY.getBoolean();
    }

    @Override
    public int getSelectorThreadCount() {
        return this.node.groupProperties.IO_THREAD_COUNT.getInteger();
    }

    @Override
    public void onDisconnect(Address endpoint) {
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public long getConnectionMonitorInterval() {
        return this.node.groupProperties.CONNECTION_MONITOR_INTERVAL.getLong();
    }

    @Override
    public int getConnectionMonitorMaxFaults() {
        return this.node.groupProperties.CONNECTION_MONITOR_MAX_FAULTS.getInteger();
    }

    @Override
    public void executeAsync(Runnable runnable) {
        this.nodeEngine.getExecutionService().execute("hz:io", runnable);
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public Data toData(Object obj) {
        return this.nodeEngine.toData(obj);
    }

    @Override
    public Object toObject(Data data) {
        return this.nodeEngine.toObject(data);
    }

    @Override
    public SerializationService getSerializationService() {
        return this.node.getSerializationService();
    }

    @Override
    public PortableContext getPortableContext() {
        return this.node.getSerializationService().getPortableContext();
    }

    @Override
    public Collection<Integer> getOutboundPorts() {
        NetworkConfig networkConfig = this.node.getConfig().getNetworkConfig();
        Collection<String> portDefinitions = this.getPortDefinitions(networkConfig);
        Set<Integer> ports = this.getPorts(networkConfig);
        if (portDefinitions.isEmpty() && ports.isEmpty()) {
            return Collections.emptySet();
        }
        if (portDefinitions.contains("*") || portDefinitions.contains("0")) {
            return Collections.emptySet();
        }
        this.transformPortDefinitionsToPorts(portDefinitions, ports);
        if (ports.contains(0)) {
            return Collections.emptySet();
        }
        return ports;
    }

    private void transformPortDefinitionsToPorts(Collection<String> portDefinitions, Set<Integer> ports) {
        for (String portDef : portDefinitions) {
            String[] portDefs;
            for (String def : portDefs = portDef.split("[,; ]")) {
                int dashPos = (def = def.trim()).indexOf(45);
                if (dashPos > 0) {
                    int start = Integer.parseInt(def.substring(0, dashPos));
                    int end = Integer.parseInt(def.substring(dashPos + 1));
                    for (int port = start; port <= end; ++port) {
                        ports.add(port);
                    }
                    continue;
                }
                ports.add(Integer.parseInt(def));
            }
        }
    }

    private Set<Integer> getPorts(NetworkConfig networkConfig) {
        return networkConfig.getOutboundPorts() == null ? new HashSet<Integer>() : new HashSet<Integer>(networkConfig.getOutboundPorts());
    }

    private Collection<String> getPortDefinitions(NetworkConfig networkConfig) {
        return networkConfig.getOutboundPortDefinitions() == null ? Collections.emptySet() : networkConfig.getOutboundPortDefinitions();
    }
}

