/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.GetOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class MapGetRequest
extends KeyBasedClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private String name;
    private Data key;
    private boolean async;
    private transient long startTime;

    public MapGetRequest() {
    }

    public MapGetRequest(String name, Data key) {
        this.name = name;
        this.key = key;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        return new GetOperation(this.name, this.key);
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void beforeResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService();
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(this.name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(this.name).incrementGets(latency);
        }
    }

    public void setAsAsync() {
        this.async = true;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("a", this.async);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.async = reader.readBoolean("a");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
    }

    @Override
    public MapPermission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        if (this.async) {
            return "getAsync";
        }
        return "get";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }
}

