/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.InvocationClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.QueryResult;
import com.hazelcast.map.impl.operation.QueryOperation;
import com.hazelcast.map.impl.operation.QueryPartitionOperation;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

abstract class AbstractMapQueryRequest
extends InvocationClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    protected IterationType iterationType;
    private String name;

    public AbstractMapQueryRequest() {
    }

    public AbstractMapQueryRequest(String name, IterationType iterationType) {
        this.name = name;
        this.iterationType = iterationType;
    }

    @Override
    protected final void invoke() {
        Collection<MemberImpl> members = this.getClientEngine().getClusterService().getMemberList();
        int partitionCount = this.getClientEngine().getPartitionService().getPartitionCount();
        HashSet<Integer> plist = new HashSet<Integer>(partitionCount);
        ClientEndpoint endpoint = this.getEndpoint();
        QueryResultSet result = new QueryResultSet(null, this.iterationType, true);
        try {
            ArrayList<Future> futures = new ArrayList<Future>();
            Predicate predicate = this.getPredicate();
            this.createInvocations(members, futures, predicate);
            this.collectResults(plist, result, futures);
            if (this.hasMissingPartitions(partitionCount, plist)) {
                List<Integer> missingList = this.findMissingPartitions(partitionCount, plist);
                ArrayList<Future> missingFutures = new ArrayList<Future>(missingList.size());
                this.createInvocationsForMissingPartitions(predicate, missingList, missingFutures);
                this.collectResultsFromMissingPartitions(result, missingFutures);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        endpoint.sendResponse(result, this.getCallId());
    }

    private boolean hasMissingPartitions(int partitionCount, Set<Integer> plist) {
        return plist.size() != partitionCount;
    }

    private void collectResultsFromMissingPartitions(QueryResultSet result, List<Future> futures) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            QueryResult queryResult = (QueryResult)future.get();
            result.addAll(queryResult.getResult());
        }
    }

    private void createInvocationsForMissingPartitions(Predicate predicate, List<Integer> missingList, List<Future> futures) {
        for (Integer pid : missingList) {
            QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
            queryPartitionOperation.setPartitionId(pid);
            try {
                InternalCompletableFuture f = this.createInvocationBuilder("hz:impl:mapService", (Operation)queryPartitionOperation, pid).invoke();
                futures.add(f);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    private List<Integer> findMissingPartitions(int partitionCount, Set<Integer> plist) {
        ArrayList<Integer> missingList = new ArrayList<Integer>();
        for (int i = 0; i < partitionCount; ++i) {
            if (plist.contains(i)) continue;
            missingList.add(i);
        }
        return missingList;
    }

    private void collectResults(Set<Integer> plist, QueryResultSet result, List<Future> flist) throws InterruptedException, ExecutionException {
        for (Future future : flist) {
            Collection<Integer> partitionIds;
            QueryResult queryResult = (QueryResult)future.get();
            if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null) continue;
            plist.addAll(partitionIds);
            result.addAll(queryResult.getResult());
        }
    }

    private void createInvocations(Collection<MemberImpl> members, List<Future> flist, Predicate predicate) {
        for (MemberImpl member : members) {
            InternalCompletableFuture future = this.createInvocationBuilder("hz:impl:mapService", (Operation)new QueryOperation(this.name, predicate), member.getAddress()).invoke();
            flist.add(future);
        }
    }

    protected abstract Predicate getPredicate();

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public final int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("t", this.iterationType.toString());
        this.writePortableInner(writer);
    }

    protected abstract void writePortableInner(PortableWriter var1) throws IOException;

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.iterationType = IterationType.valueOf(reader.readUTF("t"));
        this.readPortableInner(reader);
    }

    protected abstract void readPortableInner(PortableReader var1) throws IOException;

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

