/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.Logger;

public class DefaultStreamConnector
implements StreamConnector {
    private static final Logger logger = Logger.getLogger(DefaultStreamConnector.class);
    public static final int BIND_RETRIES_DEFAULT_VALUE = 50;
    public static final String BIND_RETRIES_PROPERTY_NAME = "net.java.sip.communicator.service.media.BIND_RETRIES";
    public static final String MAX_PORT_NUMBER_PROPERTY_NAME = "net.java.sip.communicator.service.media.MAX_PORT_NUMBER";
    private static int maxPort = -1;
    public static final String MIN_PORT_NUMBER_PROPERTY_NAME = "net.java.sip.communicator.service.media.MIN_PORT_NUMBER";
    private static int minPort = -1;
    private final InetAddress bindAddr;
    protected DatagramSocket controlSocket;
    protected DatagramSocket dataSocket;
    protected boolean rtcpmux = false;

    private static synchronized DatagramSocket createDatagramSocket(InetAddress bindAddr) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        int bindRetries = 50;
        if (cfg != null) {
            bindRetries = cfg.getInt(BIND_RETRIES_PROPERTY_NAME, bindRetries);
        }
        if (maxPort < 0) {
            maxPort = 6000;
            if (cfg != null) {
                maxPort = cfg.getInt(MAX_PORT_NUMBER_PROPERTY_NAME, maxPort);
            }
        }
        for (int i = 0; i < bindRetries; ++i) {
            int port;
            if (minPort < 0 || minPort > maxPort) {
                minPort = 5000;
                if (cfg != null) {
                    minPort = cfg.getInt(MIN_PORT_NUMBER_PROPERTY_NAME, minPort);
                }
            }
            ++minPort;
            try {
                return bindAddr == null ? new DatagramSocket(port) : new DatagramSocket(port, bindAddr);
            }
            catch (SocketException se) {
                logger.warn("Retrying a bind because of a failure to bind to address " + bindAddr + " and port " + port, se);
                continue;
            }
        }
        return null;
    }

    public DefaultStreamConnector() {
        this(null, null);
    }

    public DefaultStreamConnector(InetAddress bindAddr) {
        this.bindAddr = bindAddr;
    }

    public DefaultStreamConnector(DatagramSocket dataSocket, DatagramSocket controlSocket) {
        this(dataSocket, controlSocket, false);
    }

    public DefaultStreamConnector(DatagramSocket dataSocket, DatagramSocket controlSocket, boolean rtcpmux) {
        this.controlSocket = controlSocket;
        this.dataSocket = dataSocket;
        this.bindAddr = null;
        this.rtcpmux = rtcpmux;
    }

    @Override
    public void close() {
        if (this.controlSocket != null) {
            this.controlSocket.close();
        }
        if (this.dataSocket != null) {
            this.dataSocket.close();
        }
    }

    @Override
    public DatagramSocket getControlSocket() {
        if (this.controlSocket == null && this.bindAddr != null) {
            this.controlSocket = DefaultStreamConnector.createDatagramSocket(this.bindAddr);
        }
        return this.controlSocket;
    }

    @Override
    public DatagramSocket getDataSocket() {
        if (this.dataSocket == null && this.bindAddr != null) {
            this.dataSocket = DefaultStreamConnector.createDatagramSocket(this.bindAddr);
        }
        return this.dataSocket;
    }

    @Override
    public Socket getDataTCPSocket() {
        return null;
    }

    @Override
    public Socket getControlTCPSocket() {
        return null;
    }

    @Override
    public StreamConnector.Protocol getProtocol() {
        return StreamConnector.Protocol.UDP;
    }

    @Override
    public void started() {
    }

    @Override
    public void stopped() {
    }

    @Override
    public boolean isRtcpmux() {
        return this.rtcpmux;
    }
}

