/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.media.protocol.DataSource;
import javax.media.rtp.SendStream;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.rtp.translator.SendStreamImpl;

class SendStreamDesc {
    public final DataSource dataSource;
    public final SendStream sendStream;
    private final List<SendStreamImpl> sendStreams = new LinkedList<SendStreamImpl>();
    private int started;
    public final int streamIndex;
    private final RTPTranslatorImpl translator;

    public SendStreamDesc(RTPTranslatorImpl translator, DataSource dataSource, int streamIndex, SendStream sendStream) {
        this.translator = translator;
        this.dataSource = dataSource;
        this.sendStream = sendStream;
        this.streamIndex = streamIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(SendStreamImpl sendStream) {
        boolean close = false;
        SendStreamDesc sendStreamDesc = this;
        synchronized (sendStreamDesc) {
            if (this.sendStreams.contains(sendStream)) {
                this.sendStreams.remove(sendStream);
                close = this.sendStreams.isEmpty();
            }
        }
        if (close) {
            this.translator.closeSendStream(this);
        }
    }

    public synchronized SendStreamImpl getSendStream(StreamRTPManager streamRTPManager, boolean create) {
        for (SendStreamImpl sendStream : this.sendStreams) {
            if (sendStream.streamRTPManager != streamRTPManager) continue;
            return sendStream;
        }
        if (create) {
            SendStreamImpl sendStream = new SendStreamImpl(streamRTPManager, this);
            this.sendStreams.add(sendStream);
            return sendStream;
        }
        return null;
    }

    public synchronized int getSendStreamCount() {
        return this.sendStreams.size();
    }

    synchronized void start(SendStreamImpl sendStream) throws IOException {
        if (this.sendStreams.contains(sendStream)) {
            if (this.started < 1) {
                this.sendStream.start();
                this.started = 1;
            } else {
                ++this.started;
            }
        }
    }

    synchronized void stop(SendStreamImpl sendStream) throws IOException {
        if (this.sendStreams.contains(sendStream)) {
            if (this.started == 1) {
                this.sendStream.stop();
                this.started = 0;
            } else if (this.started > 1) {
                --this.started;
            }
        }
    }
}

