/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.util.LinkedList;
import java.util.List;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.control.DiagnosticsControl;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.AudioSystem2;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.CoreAudioDevice;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.PortAudioRenderer;
import org.jitsi.impl.neomedia.portaudio.Pa;
import org.jitsi.util.Logger;

public class PortAudioSystem
extends AudioSystem2 {
    private static final String LOCATOR_PROTOCOL = "portaudio";
    private static final Logger logger = Logger.getLogger(PortAudioSystem.class);
    private Runnable devicesChangedCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double getSupportedSampleRate(boolean input, int deviceIndex, int channelCount, long sampleFormat) {
        double supportedSampleRate;
        long deviceInfo = Pa.GetDeviceInfo(deviceIndex);
        if (deviceInfo != 0L) {
            double defaultSampleRate = Pa.DeviceInfo_getDefaultSampleRate(deviceInfo);
            if (defaultSampleRate >= MediaUtils.MAX_AUDIO_SAMPLE_RATE) {
                supportedSampleRate = defaultSampleRate;
            } else {
                long streamParameters = Pa.StreamParameters_new(deviceIndex, channelCount, sampleFormat, 0.0);
                if (streamParameters == 0L) {
                    supportedSampleRate = defaultSampleRate;
                } else {
                    try {
                        long outputParameters;
                        long inputParameters;
                        if (input) {
                            inputParameters = streamParameters;
                            outputParameters = 0L;
                        } else {
                            inputParameters = 0L;
                            outputParameters = streamParameters;
                        }
                        boolean formatIsSupported = Pa.IsFormatSupported(inputParameters, outputParameters, 44100.0);
                        supportedSampleRate = formatIsSupported ? 44100.0 : defaultSampleRate;
                    }
                    finally {
                        Pa.StreamParameters_free(streamParameters);
                    }
                }
            }
        } else {
            supportedSampleRate = 44100.0;
        }
        return supportedSampleRate;
    }

    public static void monitorFunctionalHealth(DiagnosticsControl diagnosticsControl) {
    }

    PortAudioSystem() throws Exception {
        super(LOCATOR_PROTOCOL, 15);
    }

    @Override
    protected void doInitialize() throws Exception {
        int deviceCount = Pa.GetDeviceCount();
        int channels = 1;
        int sampleSizeInBits = 16;
        long sampleFormat = Pa.getPaSampleFormat(sampleSizeInBits);
        int defaultInputDeviceIndex = Pa.GetDefaultInputDevice();
        int defaultOutputDeviceIndex = Pa.GetDefaultOutputDevice();
        LinkedList<CaptureDeviceInfo2> captureAndPlaybackDevices = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> captureDevices = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> playbackDevices = new LinkedList<CaptureDeviceInfo2>();
        boolean loggerIsDebugEnabled = logger.isDebugEnabled();
        if (CoreAudioDevice.isLoaded) {
            CoreAudioDevice.initDevices();
        }
        for (int deviceIndex = 0; deviceIndex < deviceCount; ++deviceIndex) {
            String locatorRemainder;
            String modelIdentifier;
            long deviceInfo = Pa.GetDeviceInfo(deviceIndex);
            String name = Pa.DeviceInfo_getName(deviceInfo);
            if (name != null) {
                name = name.trim();
            }
            int maxInputChannels = Pa.DeviceInfo_getMaxInputChannels(deviceInfo);
            int maxOutputChannels = Pa.DeviceInfo_getMaxOutputChannels(deviceInfo);
            String transportType = Pa.DeviceInfo_getTransportType(deviceInfo);
            String deviceUID = Pa.DeviceInfo_getDeviceUID(deviceInfo);
            if (deviceUID == null) {
                modelIdentifier = null;
                locatorRemainder = name;
            } else {
                modelIdentifier = CoreAudioDevice.isLoaded ? CoreAudioDevice.getDeviceModelIdentifier(deviceUID) : null;
                locatorRemainder = deviceUID;
            }
            List<CaptureDeviceInfo2> existingCdis = this.getDevices(AudioSystem.DataFlow.CAPTURE);
            CaptureDeviceInfo2 cdi = null;
            if (existingCdis != null) {
                for (CaptureDeviceInfo2 existingCdi : existingCdis) {
                    String id = existingCdi.getIdentifier();
                    if (!id.equals(deviceUID) && !id.equals(name)) continue;
                    cdi = existingCdi;
                    break;
                }
            }
            if (cdi == null) {
                cdi = new CaptureDeviceInfo2(name, new MediaLocator("portaudio:#" + locatorRemainder), new Format[]{new AudioFormat("LINEAR", maxInputChannels > 0 ? PortAudioSystem.getSupportedSampleRate(true, deviceIndex, channels, sampleFormat) : 44100.0, sampleSizeInBits, channels, 0, 1, -1, -1.0, Format.byteArray)}, deviceUID, transportType, modelIdentifier);
            }
            if (maxInputChannels > 0) {
                LinkedList<CaptureDeviceInfo2> devices = maxOutputChannels > 0 ? captureAndPlaybackDevices : captureDevices;
                if (deviceIndex == defaultInputDeviceIndex || maxOutputChannels > 0 && deviceIndex == defaultOutputDeviceIndex) {
                    devices.add(0, cdi);
                    if (loggerIsDebugEnabled) {
                        logger.debug("Added default capture device: " + name);
                    }
                } else {
                    devices.add(cdi);
                    if (loggerIsDebugEnabled) {
                        logger.debug("Added capture device: " + name);
                    }
                }
                if (!loggerIsDebugEnabled || maxInputChannels <= 0) continue;
                if (deviceIndex == defaultOutputDeviceIndex) {
                    logger.debug("Added default playback device: " + name);
                    continue;
                }
                logger.debug("Added playback device: " + name);
                continue;
            }
            if (maxOutputChannels <= 0) continue;
            if (deviceIndex == defaultOutputDeviceIndex) {
                playbackDevices.add(0, cdi);
                if (!loggerIsDebugEnabled) continue;
                logger.debug("Added default playback device: " + name);
                continue;
            }
            playbackDevices.add(cdi);
            if (!loggerIsDebugEnabled) continue;
            logger.debug("Added playback device: " + name);
        }
        if (CoreAudioDevice.isLoaded) {
            CoreAudioDevice.freeDevices();
        }
        PortAudioSystem.bubbleUpUsbDevices(captureDevices);
        PortAudioSystem.bubbleUpUsbDevices(playbackDevices);
        if (!captureDevices.isEmpty() && !playbackDevices.isEmpty()) {
            PortAudioSystem.matchDevicesByName(captureDevices, playbackDevices);
        }
        if (!captureAndPlaybackDevices.isEmpty()) {
            PortAudioSystem.bubbleUpUsbDevices(captureAndPlaybackDevices);
            for (int i = captureAndPlaybackDevices.size() - 1; i >= 0; --i) {
                CaptureDeviceInfo2 cdi = (CaptureDeviceInfo2)captureAndPlaybackDevices.get(i);
                captureDevices.add(0, cdi);
                playbackDevices.add(0, cdi);
            }
        }
        this.setCaptureDevices(captureDevices);
        this.setPlaybackDevices(playbackDevices);
        if (this.devicesChangedCallback == null) {
            this.devicesChangedCallback = new Runnable(){

                @Override
                public void run() {
                    try {
                        PortAudioSystem.this.reinitialize();
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn("Failed to reinitialize PortAudio devices", t);
                    }
                }
            };
            Pa.setDevicesChangedCallback(this.devicesChangedCallback);
        }
    }

    @Override
    protected String getRendererClassName() {
        return PortAudioRenderer.class.getName();
    }

    @Override
    public String toString() {
        return "PortAudio";
    }

    @Override
    protected void updateAvailableDeviceList() {
        Pa.UpdateAvailableDeviceList();
    }
}

