/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.vp8;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import javax.media.Buffer;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.util.Logger;

public class DePacketizer
extends AbstractCodec2 {
    private static final Logger logger = Logger.getLogger(DePacketizer.class);
    private static final boolean TRACE = logger.isTraceEnabled();
    private static final Comparator<? super Long> seqNumComparator = new Comparator<Long>(){

        @Override
        public int compare(Long a, Long b) {
            if (a.equals(b)) {
                return 0;
            }
            if (a > b) {
                if (a - b < 32768L) {
                    return 1;
                }
                return -1;
            }
            if (b - a < 32768L) {
                return -1;
            }
            return 1;
        }
    };
    private SortedMap<Long, Container> data = new TreeMap<Long, Container>(seqNumComparator);
    private Queue<Container> free = new ArrayBlockingQueue<Container>(100);
    private long firstSeq = -1L;
    private long lastSeq = -1L;
    private int pictureId = -1;
    private long timestamp = -1L;
    private boolean empty = true;
    private boolean haveEnd = false;
    private boolean haveStart = false;
    private int frameLength = 0;
    private long lastSentSeq = -1L;

    public DePacketizer() {
        super("VP8 RTP DePacketizer", VideoFormat.class, new VideoFormat[]{new VideoFormat("VP8")});
        this.inputFormats = new VideoFormat[]{new VideoFormat("VP8/rtp")};
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        if (logger.isInfoEnabled()) {
            logger.info("Opened VP8 depacketizer");
        }
    }

    private void reinit() {
        this.timestamp = -1L;
        this.lastSeq = -1L;
        this.firstSeq = -1L;
        this.pictureId = -1;
        this.empty = true;
        this.haveStart = false;
        this.haveEnd = false;
        this.frameLength = 0;
        Iterator<Map.Entry<Long, Container>> it = this.data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Container> e = it.next();
            this.free.offer(e.getValue());
            it.remove();
        }
    }

    private boolean frameComplete() {
        return this.haveStart && this.haveEnd && !this.haveMissing();
    }

    private boolean haveMissing() {
        Set<Long> seqs = this.data.keySet();
        long s = this.firstSeq;
        while (s != this.lastSeq) {
            if (!seqs.contains(s)) {
                return true;
            }
            s = (s + 1L) % 65536L;
        }
        return false;
    }

    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        int inOffset;
        byte[] inData = (byte[])inBuffer.getData();
        if (!VP8PayloadDescriptor.isValid(inData, inOffset = inBuffer.getOffset())) {
            logger.warn("Invalid RTP/VP8 packet discarded.");
            outBuffer.setDiscard(true);
            return 1;
        }
        long inSeq = inBuffer.getSequenceNumber();
        long inRtpTimestamp = inBuffer.getRtpTimeStamp();
        int inPictureId = VP8PayloadDescriptor.getPictureId(inData, inOffset);
        boolean inMarker = (inBuffer.getFlags() & 0x800) != 0;
        boolean inIsStartOfFrame = VP8PayloadDescriptor.isStartOfFrame(inData, inOffset);
        int inLength = inBuffer.getLength();
        int inPdSize = VP8PayloadDescriptor.getSize(inData, inOffset);
        int inPayloadLength = inLength - inPdSize;
        if (this.empty && this.lastSentSeq != -1L && seqNumComparator.compare((Long)inSeq, (Long)this.lastSentSeq) != 1) {
            if (logger.isInfoEnabled()) {
                logger.info("Discarding old packet (while empty) " + inSeq);
            }
            outBuffer.setDiscard(true);
            return 0;
        }
        if (!this.empty && (inPictureId != -1 && this.pictureId != -1 && inPictureId != this.pictureId) | (this.timestamp != -1L && inRtpTimestamp != -1L && inRtpTimestamp != this.timestamp)) {
            if (seqNumComparator.compare((Long)inSeq, (Long)this.firstSeq) != 1) {
                if (logger.isInfoEnabled()) {
                    logger.info("Discarding old packet " + inSeq);
                }
                outBuffer.setDiscard(true);
                return 0;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Discarding saved packets on arrival of a packet for a subsequent frame: " + inSeq);
            }
            this.reinit();
        }
        if (this.empty && inMarker && inIsStartOfFrame) {
            byte[] outData = DePacketizer.validateByteArraySize(outBuffer, inPayloadLength, false);
            System.arraycopy(inData, inOffset + inPdSize, outData, 0, inPayloadLength);
            outBuffer.setOffset(0);
            outBuffer.setLength(inPayloadLength);
            outBuffer.setRtpTimeStamp(inBuffer.getRtpTimeStamp());
            if (TRACE) {
                logger.trace("Out PictureID=" + inPictureId);
            }
            this.lastSentSeq = inSeq;
            return 0;
        }
        Container container = this.free.poll();
        if (container == null) {
            container = new Container();
        }
        if (container.buf == null || container.buf.length < inPayloadLength) {
            Container.access$302(container, new byte[inPayloadLength]);
        }
        if (this.data.get(inSeq) != null) {
            if (logger.isInfoEnabled()) {
                logger.info("(Probable) duplicate packet detected, discarding " + inSeq);
            }
            outBuffer.setDiscard(true);
            return 0;
        }
        System.arraycopy(inData, inOffset + inPdSize, container.buf, 0, inPayloadLength);
        container.len = inPayloadLength;
        this.data.put(inSeq, container);
        this.frameLength += inPayloadLength;
        if (this.firstSeq == -1L || seqNumComparator.compare((Long)this.firstSeq, (Long)inSeq) == 1) {
            this.firstSeq = inSeq;
        }
        if (this.lastSeq == -1L || seqNumComparator.compare((Long)inSeq, (Long)this.lastSeq) == 1) {
            this.lastSeq = inSeq;
        }
        if (this.empty) {
            this.empty = false;
            this.timestamp = inRtpTimestamp;
            this.pictureId = inPictureId;
        }
        if (inMarker) {
            this.haveEnd = true;
        }
        if (inIsStartOfFrame) {
            this.haveStart = true;
        }
        if (this.frameComplete()) {
            byte[] outData = DePacketizer.validateByteArraySize(outBuffer, this.frameLength, false);
            int ptr = 0;
            for (Map.Entry<Long, Container> entry : this.data.entrySet()) {
                Container b = entry.getValue();
                System.arraycopy(b.buf, 0, outData, ptr, b.len);
                ptr += b.len;
            }
            outBuffer.setOffset(0);
            outBuffer.setLength(this.frameLength);
            outBuffer.setRtpTimeStamp(inBuffer.getRtpTimeStamp());
            if (TRACE) {
                logger.trace("Out PictureID=" + inPictureId);
            }
            this.lastSentSeq = this.lastSeq;
            this.reinit();
            return 0;
        }
        outBuffer.setDiscard(true);
        return 4;
    }

    private static class Container {
        private byte[] buf;
        private int len = 0;

        private Container() {
        }

        static /* synthetic */ byte[] access$302(Container x0, byte[] x1) {
            x0.buf = x1;
            return x1;
        }
    }

    static class VP8PayloadDescriptor {
        private static final byte I_BIT = -128;
        private static final byte K_BIT = 16;
        private static final byte L_BIT = 64;
        private static final byte M_BIT = -128;
        public static final int MAX_LENGTH = 6;
        private static final byte S_BIT = 16;
        private static final byte T_BIT = 32;
        private static final byte X_BIT = -128;

        VP8PayloadDescriptor() {
        }

        public static byte[] create(boolean startOfPartition) {
            byte[] pd = new byte[]{startOfPartition ? (byte)16 : 0};
            return pd;
        }

        public static int getSize(byte[] input, int offset) {
            if (!VP8PayloadDescriptor.isValid(input, offset)) {
                return -1;
            }
            if ((input[offset] & 0xFFFFFF80) == 0) {
                return 1;
            }
            int size = 2;
            if ((input[offset + 1] & 0xFFFFFF80) != 0) {
                ++size;
                if ((input[offset + 2] & 0xFFFFFF80) != 0) {
                    ++size;
                }
            }
            if ((input[offset + 1] & 0x40) != 0) {
                ++size;
            }
            if ((input[offset + 1] & 0x30) != 0) {
                ++size;
            }
            return size;
        }

        private static int getPictureId(byte[] input, int offset) {
            boolean isLong;
            if (!VP8PayloadDescriptor.isValid(input, offset)) {
                return -1;
            }
            if ((input[offset] & 0xFFFFFF80) == 0 || (input[offset + 1] & 0xFFFFFF80) == 0) {
                return -1;
            }
            boolean bl = isLong = (input[offset + 2] & 0xFFFFFF80) != 0;
            if (isLong) {
                return (input[offset + 2] & 0x7F) << 8 | input[offset + 3] & 0xFF;
            }
            return input[offset + 2] & 0x7F;
        }

        private static boolean isValid(byte[] input, int offset) {
            return true;
        }

        public static boolean isStartOfPartition(byte[] input, int offset) {
            return (input[offset] & 0x10) != 0;
        }

        public static boolean isStartOfFrame(byte[] input, int offset) {
            return VP8PayloadDescriptor.isStartOfPartition(input, offset) && VP8PayloadDescriptor.getPartitionId(input, offset) == 0;
        }

        public static int getPartitionId(byte[] input, int offset) {
            return input[offset] & 7;
        }
    }
}

