/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSRCTable<T> {
    static final int INCR = 16;
    Object[] objList;
    int[] ssrcList = new int[16];
    int total = 0;

    public SSRCTable() {
        this.objList = new Object[this.ssrcList.length];
    }

    public Enumeration<T> elements() {
        return new Enumeration<T>(){
            private int next = 0;

            @Override
            public boolean hasMoreElements() {
                return this.next < SSRCTable.this.total;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T nextElement() {
                SSRCTable sSRCTable = SSRCTable.this;
                synchronized (sSRCTable) {
                    if (this.next < SSRCTable.this.total) {
                        Object t = SSRCTable.this.objList[this.next++];
                        return t;
                    }
                }
                throw new NoSuchElementException("SSRCTable Enumeration");
            }
        };
    }

    public synchronized T get(int ssrc) {
        int i = this.indexOf(ssrc);
        if (i < 0) {
            return null;
        }
        Object t = this.objList[i];
        return (T)t;
    }

    public synchronized int getSSRC(T obj) {
        for (int i = 0; i < this.total; ++i) {
            if (this.objList[i] != obj) continue;
            return this.ssrcList[i];
        }
        return 0;
    }

    private int indexOf(int ssrc) {
        if (this.total <= 3) {
            if (this.total > 0 && this.ssrcList[0] == ssrc) {
                return 0;
            }
            if (this.total > 1 && this.ssrcList[1] == ssrc) {
                return 1;
            }
            return this.total <= 2 || this.ssrcList[2] != ssrc ? -1 : 2;
        }
        if (this.ssrcList[0] == ssrc) {
            return 0;
        }
        if (this.ssrcList[this.total - 1] == ssrc) {
            return this.total - 1;
        }
        int i = 0;
        int j = this.total - 1;
        do {
            int x;
            if (this.ssrcList[x = (j - i) / 2 + i] == ssrc) {
                return x;
            }
            if (ssrc > this.ssrcList[x]) {
                i = x + 1;
                continue;
            }
            if (ssrc >= this.ssrcList[x]) continue;
            j = x;
        } while (i < j);
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized int[] keysToArray(int[] array) {
        int length = this.size();
        if (array == null || array.length < length) {
            array = new int[length];
        }
        System.arraycopy(this.ssrcList, 0, array, 0, length);
        if (length < array.length) {
            Arrays.fill(array, length, array.length, 0);
        }
        return array;
    }

    public synchronized void put(int ssrc, T obj) {
        int i;
        if (this.total == 0) {
            this.ssrcList[0] = ssrc;
            this.objList[0] = obj;
            this.total = 1;
            return;
        }
        for (i = 0; i < this.total; ++i) {
            if (this.ssrcList[i] < ssrc) continue;
            if (this.ssrcList[i] != ssrc) break;
            this.objList[i] = obj;
            return;
        }
        int[] sl = this.ssrcList;
        Object[] ol = this.objList;
        if (this.total == this.ssrcList.length) {
            sl = new int[this.ssrcList.length + 16];
            ol = new Object[this.objList.length + 16];
        }
        if (this.ssrcList != sl && i > 0) {
            System.arraycopy(this.ssrcList, 0, sl, 0, i);
            System.arraycopy(this.objList, 0, ol, 0, i);
        }
        if (i < this.total) {
            System.arraycopy(this.ssrcList, i, sl, i + 1, this.total - i);
            System.arraycopy(this.objList, i, ol, i + 1, this.total - i);
        }
        this.ssrcList = sl;
        this.objList = ol;
        this.ssrcList[i] = ssrc;
        this.objList[i] = obj;
        ++this.total;
    }

    public synchronized T remove(int ssrc) {
        int i = this.indexOf(ssrc);
        if (i < 0) {
            return null;
        }
        Object res = this.objList[i];
        while (i < this.total - 1) {
            this.ssrcList[i] = this.ssrcList[i + 1];
            this.objList[i] = this.objList[i + 1];
            ++i;
        }
        this.ssrcList[this.total - 1] = 0;
        this.objList[this.total - 1] = null;
        --this.total;
        return (T)res;
    }

    public synchronized void removeAll() {
        for (int i = 0; i < this.total; ++i) {
            this.ssrcList[i] = 0;
            this.objList[i] = null;
        }
        this.total = 0;
    }

    public synchronized void removeObj(T obj) {
        int i;
        if (obj == null) {
            return;
        }
        for (i = 0; i < this.total && this.objList[i] != obj; ++i) {
        }
        if (i >= this.total) {
            return;
        }
        while (i < this.total - 1) {
            this.ssrcList[i] = this.ssrcList[i + 1];
            this.objList[i] = this.objList[i + 1];
            ++i;
        }
        this.ssrcList[this.total - 1] = 0;
        this.objList[this.total - 1] = null;
        --this.total;
    }

    public int size() {
        return this.total;
    }

    public synchronized T[] valuesToArray(T[] array) {
        int length = this.size();
        Class componentType = array == null ? Object.class : (array.length < length ? array.getClass().getComponentType() : null);
        if (componentType != null) {
            array = (Object[])Array.newInstance(componentType, length);
        }
        System.arraycopy(this.objList, 0, array, 0, length);
        if (length < array.length) {
            Arrays.fill(array, length, array.length, null);
        }
        return array;
    }
}

