/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.Buffer;

class JitterBuffer {
    private int capacity;
    final Condition condition;
    private Buffer[] elements;
    private int length;
    final Lock lock;
    private int locked;
    private int offset;

    public JitterBuffer(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity");
        }
        this.elements = new Buffer[capacity];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = new Buffer();
        }
        this.capacity = capacity;
        this.length = 0;
        this.locked = -1;
        this.offset = 0;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public void addPkt(Buffer buffer) {
        this.assertLocked(buffer);
        if (this.noMoreFree()) {
            throw new IllegalStateException("noMoreFree");
        }
        long firstSN = this.getFirstSeq();
        long lastSN = this.getLastSeq();
        long bufferSN = buffer.getSequenceNumber();
        if (firstSN == 0x7FFFFFFFFFFFFFFEL && lastSN == 0x7FFFFFFFFFFFFFFEL) {
            this.append(buffer);
        } else if (bufferSN < firstSN) {
            this.prepend(buffer);
        } else if (firstSN < bufferSN && bufferSN < lastSN) {
            this.insert(buffer);
        } else if (bufferSN > lastSN) {
            this.append(buffer);
        } else {
            this.returnFree(buffer);
        }
        this.locked = -1;
    }

    private void append(Buffer buffer) {
        int index = (this.offset + this.length) % this.capacity;
        if (index != this.locked) {
            this.elements[this.locked] = this.elements[index];
            this.elements[index] = buffer;
        }
        ++this.length;
    }

    private void assertLocked(Buffer buffer) throws IllegalStateException {
        if (this.locked == -1) {
            throw new IllegalStateException("No Buffer has been retrieved from this JitterBuffer and has not been returned yet.");
        }
        if (buffer != this.elements[this.locked]) {
            throw new IllegalArgumentException("buffer");
        }
    }

    private void assertNotLocked() throws IllegalStateException {
        if (this.locked != -1) {
            throw new IllegalStateException("A Buffer has been retrieved from this JitterBuffer and has not been returned yet.");
        }
    }

    void dropFill(int index) {
        this.assertNotLocked();
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        index = (this.offset + index) % this.capacity;
        Buffer buffer = this.elements[index];
        if (index == this.offset) {
            this.offset = (this.offset + 1) % this.capacity;
        } else {
            int end = (this.offset + this.length - 1) % this.capacity;
            if (index != end) {
                while (index != this.offset) {
                    int i = index - 1;
                    if (i < 0) {
                        i = this.capacity - 1;
                    }
                    this.elements[index] = this.elements[i];
                    index = i;
                }
                this.elements[index] = buffer;
                this.offset = (this.offset + 1) % this.capacity;
            }
        }
        --this.length;
        this.locked = index;
        this.returnFree(buffer);
    }

    public void dropFirstFill() {
        this.returnFree(this.getFill());
    }

    boolean fillNotEmpty() {
        return this.getFillCount() != 0;
    }

    boolean freeNotEmpty() {
        return this.getFreeCount() != 0;
    }

    public int getCapacity() {
        int capacity;
        this.lock.lock();
        try {
            capacity = this.capacity;
        }
        finally {
            this.lock.unlock();
        }
        return capacity;
    }

    public Buffer getFill() {
        this.assertNotLocked();
        if (this.noMoreFill()) {
            throw new IllegalStateException("noMoreFill");
        }
        int index = this.offset;
        Buffer buffer = this.elements[index];
        this.offset = (this.offset + 1) % this.capacity;
        --this.length;
        this.locked = index;
        return buffer;
    }

    public Buffer getFill(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.elements[(this.offset + index) % this.capacity];
    }

    public int getFillCount() {
        int length;
        this.lock.lock();
        try {
            length = this.length;
        }
        finally {
            this.lock.unlock();
        }
        return length;
    }

    public long getFirstSeq() {
        return this.length == 0 ? 0x7FFFFFFFFFFFFFFEL : this.elements[this.offset].getSequenceNumber();
    }

    public Buffer getFree() {
        this.assertNotLocked();
        if (this.noMoreFree()) {
            throw new IllegalStateException("noMoreFree");
        }
        int index = (this.offset + this.length) % this.capacity;
        Buffer buffer = this.elements[index];
        this.locked = index;
        return buffer;
    }

    public int getFreeCount() {
        return this.capacity - this.length;
    }

    public long getLastSeq() {
        return this.length == 0 ? 0x7FFFFFFFFFFFFFFEL : this.elements[(this.offset + this.length - 1) % this.capacity].getSequenceNumber();
    }

    private void insert(Buffer buffer) {
        int i = this.offset;
        int end = (this.offset + this.length) % this.capacity;
        long bufferSN = buffer.getSequenceNumber();
        while (i != end && this.elements[i].getSequenceNumber() <= bufferSN) {
            if (++i < this.capacity) continue;
            i = 0;
        }
        if (i == this.offset) {
            this.prepend(buffer);
        } else if (i == end) {
            this.append(buffer);
        } else {
            this.elements[this.locked] = this.elements[end];
            int j = end;
            while (j != i) {
                int k = j - 1;
                if (k < 0) {
                    k = this.capacity - 1;
                }
                this.elements[j] = this.elements[k];
                j = k;
            }
            this.elements[i] = buffer;
            ++this.length;
        }
    }

    boolean noMoreFill() {
        return this.getFillCount() == 0;
    }

    boolean noMoreFree() {
        return this.getFreeCount() == 0;
    }

    private void prepend(Buffer buffer) {
        int index = this.offset - 1;
        if (index < 0) {
            index = this.capacity - 1;
        }
        if (index != this.locked) {
            this.elements[this.locked] = this.elements[index];
            this.elements[index] = buffer;
        }
        this.offset = index;
        ++this.length;
    }

    public void returnFree(Buffer buffer) {
        this.assertLocked(buffer);
        this.locked = -1;
    }

    public void setCapacity(int capacity) {
        int i;
        this.assertNotLocked();
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity");
        }
        if (this.capacity == capacity) {
            return;
        }
        Buffer[] elements = new Buffer[capacity];
        while (this.getFillCount() > capacity) {
            this.dropFirstFill();
        }
        int length = Math.min(this.getFillCount(), capacity);
        for (i = 0; i < length; ++i) {
            elements[i] = this.getFill(i);
        }
        for (i = length; i < capacity; ++i) {
            elements[i] = new Buffer();
        }
        this.capacity = capacity;
        this.elements = elements;
        this.length = length;
        this.offset = 0;
    }
}

