/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.video;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.media.renderer.video.JVideoComponent;

public class Java2dRenderer
implements VideoRenderer {
    private String name = "Java2D Video Renderer";
    private Format[] supportedFormats;
    private RGBFormat inputFormat;
    private JVideoComponent component;
    private Rectangle bounds = new Rectangle(0, 0, 10, 10);
    private BufferedImage bufferedImage;

    public Java2dRenderer() {
        int rMask = 0xFF0000;
        int gMask = 65280;
        int bMask = 255;
        this.supportedFormats = new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, rMask, gMask, bMask, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, bMask, gMask, rMask, 1, -1, 0, -1)};
    }

    public synchronized void close() {
        this.bufferedImage = null;
    }

    private void createImage() {
        if (this.inputFormat == null) {
            return;
        }
        Dimension size = this.inputFormat.getSize();
        if (size == null) {
            return;
        }
        int imageType = this.inputFormat.getRedMask() == 255 ? 4 : 1;
        this.bufferedImage = new BufferedImage(size.width, size.height, imageType);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new JVideoComponent();
        }
        return this.component;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public String getName() {
        return this.name;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.createImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer) {
        Object data;
        if (this.component == null) {
            return 1;
        }
        Format inFormat = buffer.getFormat();
        if (inFormat == null) {
            return 1;
        }
        if (inFormat != this.inputFormat || !inFormat.equals(this.inputFormat)) {
            if (this.setInputFormat(inFormat) == null) {
                return 1;
            }
            this.createImage();
        }
        if ((data = buffer.getData()) == null) {
            return 1;
        }
        if (inFormat.getDataType() != Format.intArray) {
            return 1;
        }
        Dimension size = this.inputFormat.getSize();
        JVideoComponent jVideoComponent = this.component;
        synchronized (jVideoComponent) {
            this.bufferedImage.getRaster().setDataElements(0, 0, size.width, size.height, data);
            this.component.setImage(this.bufferedImage);
        }
        return 0;
    }

    public void reset() {
    }

    public void setBounds(Rectangle rect) {
        this.bounds.setBounds(rect);
    }

    public boolean setComponent(Component comp) {
        return false;
    }

    public Format setInputFormat(Format format) {
        for (int i = 0; i < this.supportedFormats.length; ++i) {
            if (!format.matches(this.supportedFormats[i])) continue;
            this.inputFormat = (RGBFormat)format;
            Dimension size = this.inputFormat.getSize();
            if (size != null) {
                this.bounds.setSize(size);
            }
            this.getComponent().setPreferredSize(size);
            return format;
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }
}

