/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.dns;

import java.io.IOException;
import net.java.sip.communicator.impl.dns.UnboundResult;
import org.xbill.DNS.Message;

public class SecureMessage
extends Message {
    private boolean secure;
    private boolean bogus;
    private String bogusReason;

    public SecureMessage(UnboundResult msg) throws IOException {
        super(msg.answerPacket);
        this.secure = msg.secure;
        this.bogus = msg.bogus;
        this.bogusReason = msg.whyBogus;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isBogus() {
        return this.bogus;
    }

    public String getBogusReason() {
        return this.bogusReason;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(super.toString());
        s.append('\n');
        s.append(";; Secure: ");
        s.append(this.secure);
        s.append('\n');
        s.append(";; Bogus:  ");
        s.append(this.bogus);
        s.append('\n');
        if (this.bogus) {
            s.append(";;  Reason: ");
            s.append(this.bogusReason);
            s.append('\n');
        }
        return s.toString();
    }
}

