/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.generators;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.cryptozrtp.util.BigIntegers;

class DHParametersHelper {
    private static final BigIntegerCrypto ONE = BigIntegerCrypto.valueOf(1L);
    private static final BigIntegerCrypto TWO = BigIntegerCrypto.valueOf(2L);

    DHParametersHelper() {
    }

    static BigIntegerCrypto[] generateSafePrimes(int size, int certainty, RandomGenerator random) {
        BigIntegerCrypto q;
        BigIntegerCrypto p;
        int qLength = size - 1;
        while (!(p = (q = new BigIntegerCrypto(qLength, 2, random)).shiftLeft(1).add(ONE)).isProbablePrime(certainty) || certainty > 2 && !q.isProbablePrime(certainty)) {
        }
        return new BigIntegerCrypto[]{p, q};
    }

    static BigIntegerCrypto selectGenerator(BigIntegerCrypto p, BigIntegerCrypto q, RandomGenerator random) {
        BigIntegerCrypto g;
        BigIntegerCrypto pMinusTwo = p.subtract(TWO);
        while ((g = BigIntegers.createRandomInRange(TWO, pMinusTwo, random)).modPow(TWO, p).equals(ONE) || g.modPow(q, p).equals(ONE)) {
        }
        return g;
    }
}

