/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework.startlevel;

import java.util.concurrent.TimeUnit;
import org.jitsi.impl.osgi.framework.AsyncExecutor;
import org.jitsi.impl.osgi.framework.BundleImpl;
import org.jitsi.impl.osgi.framework.launch.FrameworkImpl;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class FrameworkStartLevelImpl
implements FrameworkStartLevel {
    private final BundleImpl bundle;
    private final AsyncExecutor<Command> executor = new AsyncExecutor(5L, TimeUnit.MINUTES);
    private int initialBundleStartLevel = 0;
    private int startLevel;

    public FrameworkStartLevelImpl(BundleImpl bundle) {
        this.bundle = bundle;
    }

    public BundleImpl getBundle() {
        return this.bundle;
    }

    private FrameworkImpl getFramework() {
        return this.getBundle().getFramework();
    }

    public int getInitialBundleStartLevel() {
        int initialBundleStartLevel = this.initialBundleStartLevel;
        if (initialBundleStartLevel == 0) {
            initialBundleStartLevel = 1;
        }
        return initialBundleStartLevel;
    }

    public synchronized int getStartLevel() {
        return this.startLevel;
    }

    public void internalSetStartLevel(int startLevel, FrameworkListener ... listeners) {
        if (startLevel < 0) {
            throw new IllegalArgumentException("startLevel");
        }
        this.executor.execute(new Command(startLevel, listeners));
    }

    public void setInitialBundleStartLevel(int initialBundleStartLevel) {
        if (initialBundleStartLevel <= 0) {
            throw new IllegalArgumentException("initialBundleStartLevel");
        }
        this.initialBundleStartLevel = initialBundleStartLevel;
    }

    public void setStartLevel(int startLevel, FrameworkListener ... listeners) {
        if (startLevel == 0) {
            throw new IllegalArgumentException("startLevel");
        }
        this.internalSetStartLevel(startLevel, listeners);
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    private class Command
    implements Runnable {
        private final FrameworkListener[] listeners;
        private final int startLevel;

        public Command(int startLevel, FrameworkListener ... listeners) {
            this.startLevel = startLevel;
            this.listeners = listeners;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int startLevel = FrameworkStartLevelImpl.this.getStartLevel();
            FrameworkImpl framework = FrameworkStartLevelImpl.this.getFramework();
            if (startLevel < this.startLevel) {
                int intermediateStartLevel = startLevel + 1;
                while (intermediateStartLevel <= this.startLevel) {
                    int oldStartLevel = FrameworkStartLevelImpl.this.getStartLevel();
                    int newStartLevel = intermediateStartLevel++;
                    framework.startLevelChanging(oldStartLevel, newStartLevel, this.listeners);
                    FrameworkStartLevelImpl frameworkStartLevelImpl = FrameworkStartLevelImpl.this;
                    synchronized (frameworkStartLevelImpl) {
                        FrameworkStartLevelImpl.this.startLevel = newStartLevel;
                    }
                    framework.startLevelChanged(oldStartLevel, newStartLevel, this.listeners);
                }
            } else if (this.startLevel < startLevel) {
                for (int intermediateStartLevel = startLevel; intermediateStartLevel > this.startLevel; --intermediateStartLevel) {
                    int oldStartLevel = FrameworkStartLevelImpl.this.getStartLevel();
                    int newStartLevel = intermediateStartLevel - 1;
                    framework.startLevelChanging(oldStartLevel, newStartLevel, this.listeners);
                    FrameworkStartLevelImpl frameworkStartLevelImpl = FrameworkStartLevelImpl.this;
                    synchronized (frameworkStartLevelImpl) {
                        FrameworkStartLevelImpl.this.startLevel = newStartLevel;
                    }
                    framework.startLevelChanged(oldStartLevel, newStartLevel, this.listeners);
                }
            } else {
                framework.startLevelChanging(startLevel, startLevel, this.listeners);
                framework.startLevelChanged(startLevel, startLevel, this.listeners);
            }
        }
    }
}

