/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncExecutor<T extends Runnable> {
    private long keepAliveTime;
    private final List<CommandFuture<T>> queue = new LinkedList<CommandFuture<T>>();
    private boolean shutdown;
    private boolean shutdownNow;
    private Thread thread;

    public AsyncExecutor() {
        this(0L, TimeUnit.MILLISECONDS);
    }

    public AsyncExecutor(long keepAliveTime, TimeUnit unit) {
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime");
        }
        this.keepAliveTime = unit.toMillis(keepAliveTime);
    }

    private synchronized boolean contains(T command) {
        for (CommandFuture<T> commandFuture : this.queue) {
            if (commandFuture.command != command) continue;
            return true;
        }
        return false;
    }

    public void execute(T command) {
        this.submit(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInThread() {
        long idleTime = -1L;
        while (true) {
            CommandFuture<T> commandFuture;
            AsyncExecutor asyncExecutor = this;
            synchronized (asyncExecutor) {
                if (this.shutdownNow) {
                    return;
                }
                if (this.queue.isEmpty()) {
                    if (idleTime == -1L) {
                        idleTime = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - idleTime > this.keepAliveTime) {
                        return;
                    }
                    boolean interrupted = false;
                    try {
                        this.wait(this.keepAliveTime);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                idleTime = -1L;
                commandFuture = this.queue.remove(0);
            }
            Object command = commandFuture.command;
            Throwable exception = null;
            try {
                command.run();
                commandFuture.setDone(exception == null ? Boolean.TRUE : exception);
                continue;
            }
            catch (Throwable t) {
                try {
                    exception = t;
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    this.uncaughtException(command, t);
                    commandFuture.setDone(exception == null ? Boolean.TRUE : exception);
                    continue;
                }
                catch (Throwable throwable) {
                    commandFuture.setDone(exception == null ? Boolean.TRUE : exception);
                    throw throwable;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepAliveTime(long keepAliveTime, TimeUnit unit) {
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime");
        }
        AsyncExecutor asyncExecutor = this;
        synchronized (asyncExecutor) {
            this.keepAliveTime = unit.toMillis(keepAliveTime);
            this.notifyAll();
        }
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> shutdownNow() {
        ArrayList<CommandFuture<T>> awaiting;
        AsyncExecutor asyncExecutor = this;
        synchronized (asyncExecutor) {
            this.shutdown = true;
            this.shutdownNow = true;
            this.notifyAll();
            boolean interrupted = false;
            while (this.thread != null) {
                try {
                    this.wait(this.keepAliveTime);
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            awaiting = new ArrayList<CommandFuture<T>>(this.queue.size());
            awaiting.addAll(this.queue);
        }
        ArrayList awaitingCommands = new ArrayList(awaiting.size());
        for (CommandFuture commandFuture : awaiting) {
            awaitingCommands.add(commandFuture.command);
            commandFuture.setDone(Boolean.FALSE);
        }
        return awaitingCommands;
    }

    public synchronized Future<?> submit(T command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (this.shutdown) {
            throw new RejectedExecutionException("shutdown");
        }
        if (this.contains(command)) {
            throw new RejectedExecutionException("contains");
        }
        CommandFuture<T> future = new CommandFuture<T>(command);
        this.queue.add(future);
        this.startThreadOrNotifyAll();
        return future;
    }

    private synchronized void startThreadOrNotifyAll() {
        if (!(this.thread != null || this.shutdown || this.shutdownNow || this.queue.isEmpty())) {
            this.thread = new Thread(this.getClass().getName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AsyncExecutor.this.runInThread();
                    }
                    finally {
                        AsyncExecutor asyncExecutor = AsyncExecutor.this;
                        synchronized (asyncExecutor) {
                            if (Thread.currentThread().equals(AsyncExecutor.this.thread)) {
                                AsyncExecutor.this.thread = null;
                                AsyncExecutor.this.startThreadOrNotifyAll();
                            }
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.notifyAll();
        }
    }

    protected void uncaughtException(T command, Throwable exception) {
        Logger.getLogger(AsyncExecutor.class.getName()).log(Level.SEVERE, "Error executing command " + command, exception);
    }

    private static class CommandFuture<T extends Runnable>
    implements Future<Object> {
        public final T command;
        private Boolean done;
        private Throwable exception;

        public CommandFuture(T command) {
            this.command = command;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public Object get() throws ExecutionException, InterruptedException {
            try {
                return this.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                throw new RuntimeException(te);
            }
        }

        @Override
        public synchronized Object get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            timeout = unit.toMillis(timeout);
            boolean timeoutException = false;
            while (true) {
                if (this.done != null) {
                    if (this.done.booleanValue()) break;
                    throw new CancellationException();
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                if (timeoutException) {
                    throw new TimeoutException();
                }
                this.wait(timeout);
                timeoutException = timeout != 0L;
            }
            return null;
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.done != null && this.done == false;
        }

        @Override
        public synchronized boolean isDone() {
            return this.done != null || this.exception != null;
        }

        synchronized void setDone(Object done) {
            if (done instanceof Boolean) {
                this.done = (Boolean)done;
            } else if (done instanceof Throwable) {
                this.exception = (Throwable)done;
            } else {
                throw new IllegalArgumentException("done");
            }
            this.notifyAll();
        }
    }
}

