/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rtcp;

import java.util.HashMap;
import java.util.Map;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import org.jitsi.impl.neomedia.rtp.translator.Payload;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.Transformer;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.rtcp.AbstractBridgeRTCPTerminationStrategy;
import org.jitsi.videobridge.rtcp.RTCPPacketPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SenderFeedbackExploder
implements Transformer<RTCPCompoundPacket> {
    private final AbstractBridgeRTCPTerminationStrategy strategy;
    private final Map<Integer, Map<Integer, SenderInformation>> lastSenderInformationMap = new HashMap<Integer, Map<Integer, SenderInformation>>();

    public SenderFeedbackExploder(AbstractBridgeRTCPTerminationStrategy strategy) {
        this.strategy = strategy;
    }

    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket inPacket) {
        RTCPCompoundPacket outPacket = inPacket;
        if (outPacket.packets != null && outPacket.packets.length != 0 && outPacket.packets[0].type == 200) {
            if (this.explodeSenderReport(outPacket)) {
                return null;
            }
            return outPacket;
        }
        return outPacket;
    }

    public void close() {
    }

    public RTCPCompoundPacket transform(RTCPCompoundPacket inPacket) {
        return inPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explodeSenderReport(boolean destIsReceiving, RTCPCompoundPacket outPacket, RTCPSRPacket senderReport, RTPTranslatorImpl rtpTranslatorImpl, Integer senderSSRC, Map<Integer, SenderInformation> receiverSenderInformationMap, MediaStream stream) {
        Map<Integer, SenderInformation> map;
        SenderInformation si;
        RTCPSRPacket sr = new RTCPSRPacket(senderSSRC.intValue(), new RTCPReportBlock[0]);
        sr.ntptimestampmsw = senderReport.ntptimestampmsw;
        sr.ntptimestamplsw = senderReport.ntptimestamplsw;
        sr.rtptimestamp = senderReport.rtptimestamp;
        sr.octetcount = senderReport.octetcount;
        sr.packetcount = senderReport.packetcount;
        Integer receiverSSRC = (int)stream.getLocalSourceID();
        if (destIsReceiving) {
            si = new SenderInformation();
            si.octetCount = senderReport.octetcount;
            si.packetCount = senderReport.packetcount;
            map = receiverSenderInformationMap;
            synchronized (map) {
                receiverSenderInformationMap.put(receiverSSRC, si);
            }
        }
        map = receiverSenderInformationMap;
        synchronized (map) {
            si = receiverSenderInformationMap.containsKey(receiverSSRC) ? receiverSenderInformationMap.get(receiverSSRC) : null;
        }
        if (si != null) {
            sr.packetcount = si.packetCount;
            sr.octetcount = si.octetCount;
        } else {
            sr.packetcount = 0L;
            sr.octetcount = 0L;
        }
        RTCPPacket[] packets = new RTCPPacket[outPacket.packets.length];
        packets[0] = sr;
        System.arraycopy(outPacket.packets, 1, packets, 1, outPacket.packets.length - 1);
        RTCPCompoundPacket compoundPacket = new RTCPCompoundPacket(packets);
        RTCPPacketPayload payload = new RTCPPacketPayload(compoundPacket);
        rtpTranslatorImpl.writeControlPayload((Payload)payload, stream);
    }

    public boolean explodeSenderReport(RTCPCompoundPacket outPacket) {
        if (outPacket.packets == null || outPacket.packets.length == 0 || outPacket.packets[0].type != 200) {
            return false;
        }
        RTCPSRPacket senderReport = (RTCPSRPacket)outPacket.packets[0];
        Conference conf = this.strategy.getConference();
        if (senderReport == null || conf == null) {
            return false;
        }
        RTPTranslator rtpTranslator = this.strategy.getRTPTranslator();
        if (rtpTranslator == null || !(rtpTranslator instanceof RTPTranslatorImpl)) {
            return false;
        }
        RTPTranslatorImpl rtpTranslatorImpl = (RTPTranslatorImpl)rtpTranslator;
        long ssrc = (long)senderReport.ssrc & 0xFFFFFFFFL;
        if (ssrc < 1L) {
            return false;
        }
        Integer senderSSRC = senderReport.ssrc;
        Map<Integer, SenderInformation> receiverSenderInformationMap = this.getReceiverSenderInformationMap(senderSSRC);
        Channel srcChannel = conf.findChannelByReceiveSSRC(ssrc, MediaType.VIDEO);
        if (srcChannel == null || !(srcChannel instanceof RtpChannel)) {
            return false;
        }
        RtpChannel srcRtpChannel = (RtpChannel)srcChannel;
        for (Content content : conf.getContents()) {
            MediaStream s;
            Recorder recorder;
            if (!MediaType.VIDEO.equals((Object)content.getMediaType())) continue;
            for (Channel destChannel : content.getChannels()) {
                RtpChannel destRtpChannel;
                MediaStream stream;
                if (!(destChannel instanceof RtpChannel) || srcRtpChannel == destChannel || (stream = (destRtpChannel = (RtpChannel)destChannel).getStream()) == null) continue;
                boolean destIsReceiving = srcRtpChannel.isInLastN(destChannel);
                if (destIsReceiving && srcRtpChannel instanceof VideoChannel) {
                    VideoChannel srcVideoChannel = (VideoChannel)srcRtpChannel;
                    if (!(destChannel instanceof VideoChannel)) {
                        destIsReceiving = false;
                    } else {
                        VideoChannel destVideoChannel = (VideoChannel)destChannel;
                        destIsReceiving = destVideoChannel.getSimulcastManager().accept(ssrc, srcVideoChannel);
                    }
                }
                this.explodeSenderReport(destIsReceiving, outPacket, senderReport, rtpTranslatorImpl, senderSSRC, receiverSenderInformationMap, stream);
            }
            if (!content.isRecording() || (recorder = content.getRecorder()) == null || (s = recorder.getMediaStream()) == null) continue;
            this.explodeSenderReport(true, outPacket, senderReport, rtpTranslatorImpl, senderSSRC, receiverSenderInformationMap, s);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, SenderInformation> getReceiverSenderInformationMap(Integer senderSSRC) {
        HashMap<Integer, SenderInformation> receiverSenderInformationMap;
        Map<Integer, Map<Integer, SenderInformation>> map = this.lastSenderInformationMap;
        synchronized (map) {
            if (this.lastSenderInformationMap.containsKey(senderSSRC)) {
                receiverSenderInformationMap = this.lastSenderInformationMap.get(senderSSRC);
            } else {
                receiverSenderInformationMap = new HashMap();
                this.lastSenderInformationMap.put(senderSSRC, receiverSenderInformationMap);
            }
        }
        return receiverSenderInformationMap;
    }

    private static class SenderInformation {
        long octetCount;
        long packetCount;

        private SenderInformation() {
        }
    }
}

