/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.influxdb;

import java.lang.reflect.Constructor;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.eventadmin.EventHandler;
import org.jitsi.videobridge.influxdb.LoggingHandler;
import org.jitsi.videobridge.osgi.ServiceUtils2;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(LoggingHandler.class);
    public static final String LOGGING_HANDLER_CLASS_PNAME = "org.jitsi.videobridge.influxdb.LOGGING_HANDLER";
    private ServiceRegistration<EventHandler> serviceRegistration;

    public void start(BundleContext bundleContext) throws Exception {
        ConfigurationService cfg = ServiceUtils2.getService(bundleContext, ConfigurationService.class);
        if (cfg.getBoolean("org.jitsi.videobridge.log.INFLUX_DB_ENABLED", false)) {
            LoggingHandler handler;
            try {
                handler = this.getHandlerInstance(cfg);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to instantiate LoggingHandler: " + e));
                return;
            }
            Hashtable<String, String[]> props = new Hashtable<String, String[]>();
            String[] topics = new String[]{"org/jitsi/*"};
            ((Dictionary)props).put("event.topics", topics);
            this.serviceRegistration = bundleContext.registerService(EventHandler.class, (Object)handler, props);
        }
    }

    private LoggingHandler getHandlerInstance(ConfigurationService cfg) throws Exception {
        String className = cfg.getString(LOGGING_HANDLER_CLASS_PNAME, LoggingHandler.class.getCanonicalName());
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(ConfigurationService.class);
        return (LoggingHandler)constructor.newInstance(cfg);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}

