/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.thumbnail;

import net.java.sip.communicator.util.Base64;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;

public class ThumbnailIQ
extends IQ
implements IQProvider {
    public static final String NAMESPACE = "urn:xmpp:bob";
    public static final String ELEMENT_NAME = "data";
    public static final String CID = "cid";
    public static final String TYPE = "type";
    private String cid;
    private String mimeType;
    private byte[] data;

    public ThumbnailIQ() {
    }

    public ThumbnailIQ(String from, String to, String cid, IQ.Type type) {
        this.cid = cid;
        this.setFrom(from);
        this.setTo(to);
        this.setType(type);
    }

    public ThumbnailIQ(String from, String to, String cid, String mimeType, byte[] data, IQ.Type type) {
        this(from, to, cid, type);
        this.data = data;
        this.mimeType = mimeType;
    }

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        int eventType;
        String elementName = parser.getName();
        String namespace = parser.getNamespace();
        if (elementName.equals(ELEMENT_NAME) && namespace.equals(NAMESPACE)) {
            this.cid = parser.getAttributeValue("", CID);
            this.mimeType = parser.getAttributeValue("", TYPE);
        }
        if ((eventType = parser.next()) == 4) {
            this.data = Base64.decode((String)parser.getText());
        }
        return this;
    }

    public String getChildElementXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\"").append(" cid").append("=\"").append(this.cid).append("\"");
        if (this.mimeType != null) {
            buf.append(" type").append("=\"").append(this.mimeType).append("\">");
        } else {
            buf.append(">");
        }
        if (this.data != null) {
            byte[] encodedData = Base64.encode((byte[])this.data);
            buf.append(new String(encodedData));
        }
        buf.append("</data>");
        return buf.toString();
    }

    public String getCid() {
        return this.cid;
    }

    public byte[] getData() {
        return this.data;
    }
}

