/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.yahooconstants;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.util.Logger;

public class YahooStatusEnum
extends PresenceStatus {
    private static Logger logger = Logger.getLogger(YahooStatusEnum.class);
    public static final YahooStatusEnum AVAILABLE = new YahooStatusEnum(65, "Available", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-online.png"));
    public static final YahooStatusEnum BE_RIGHT_BACK = new YahooStatusEnum(48, "Be Right Back", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-away.png"));
    public static final YahooStatusEnum IDLE = new YahooStatusEnum(46, "Idle", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-idle.png"));
    public static final YahooStatusEnum INVISIBLE = new YahooStatusEnum(45, "Invisible", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-invisible.png"));
    public static final YahooStatusEnum STEPPED_OUT = new YahooStatusEnum(40, "Stepped out", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-away.png"));
    public static final YahooStatusEnum OUT_TO_LUNCH = new YahooStatusEnum(39, "Out to lunch", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-lunch.png"));
    public static final YahooStatusEnum NOT_AT_HOME = new YahooStatusEnum(38, "Not at home", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-na.png"));
    public static final YahooStatusEnum NOT_AT_DESK = new YahooStatusEnum(36, "Not at desk", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-na.png"));
    public static final YahooStatusEnum NOT_IN_OFFICE = new YahooStatusEnum(34, "Not in office", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-na.png"));
    public static final YahooStatusEnum ON_VACATION = new YahooStatusEnum(33, "On vacation", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-vacation.png"));
    public static final YahooStatusEnum ON_THE_PHONE = new YahooStatusEnum(31, "On the phone", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-phone.png"));
    public static final YahooStatusEnum BUSY = new YahooStatusEnum(30, "Busy", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-busy.png"));
    public static final YahooStatusEnum OFFLINE = new YahooStatusEnum(0, "Offline", YahooStatusEnum.loadIcon("resources/images/protocol/yahoo/yahoo16x16-offline.png"));
    public static final ArrayList<YahooStatusEnum> yahooStatusSet = new ArrayList();

    protected YahooStatusEnum(int status, String statusName, byte[] statusIcon) {
        super(status, statusName, statusIcon);
    }

    public static byte[] loadIcon(String imagePath) {
        InputStream is = YahooStatusEnum.class.getClassLoader().getResourceAsStream(imagePath);
        if (is == null) {
            return null;
        }
        byte[] icon = null;
        try {
            icon = new byte[is.available()];
            is.read(icon);
        }
        catch (IOException exc) {
            logger.error((Object)("Failed to load icon: " + imagePath), (Throwable)exc);
        }
        return icon;
    }

    static {
        yahooStatusSet.add(AVAILABLE);
        yahooStatusSet.add(BE_RIGHT_BACK);
        yahooStatusSet.add(BUSY);
        yahooStatusSet.add(IDLE);
        yahooStatusSet.add(INVISIBLE);
        yahooStatusSet.add(NOT_AT_DESK);
        yahooStatusSet.add(NOT_AT_HOME);
        yahooStatusSet.add(NOT_IN_OFFICE);
        yahooStatusSet.add(OFFLINE);
        yahooStatusSet.add(ON_THE_PHONE);
        yahooStatusSet.add(ON_VACATION);
        yahooStatusSet.add(OUT_TO_LUNCH);
        yahooStatusSet.add(STEPPED_OUT);
    }
}

