/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.SoundLevelListener;
import net.java.sip.communicator.util.Logger;

public abstract class Call {
    private static final Logger logger = Logger.getLogger(Call.class);
    public static final String CONFERENCE = "conference";
    public static final String CONFERENCE_FOCUS = "conferenceFocus";
    private final String callID;
    private final List<CallChangeListener> callListeners = new Vector<CallChangeListener>();
    private final ProtocolProviderService protocolProvider;
    private final boolean defaultEncryption;
    private final boolean sipZrtpAttribute;
    private CallState callState = CallState.CALL_INITIALIZATION;
    private CallConference conference;
    private boolean isAutoAnswer = false;

    protected Call(ProtocolProviderService sourceProvider) {
        this.callID = String.valueOf(System.currentTimeMillis()) + String.valueOf(super.hashCode());
        this.protocolProvider = sourceProvider;
        AccountID accountID = this.protocolProvider.getAccountID();
        this.defaultEncryption = accountID.getAccountPropertyBoolean("DEFAULT_ENCRYPTION", true);
        this.sipZrtpAttribute = accountID.getAccountPropertyBoolean("DEFAULT_SIPZRTP_ATTRIBUTE", true);
    }

    public String getCallID() {
        return this.callID;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Call)) {
            return false;
        }
        return obj == this || ((Call)obj).getCallID().equals(this.getCallID());
    }

    public int hashCode() {
        return this.getCallID().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallChangeListener(CallChangeListener listener) {
        List<CallChangeListener> list = this.callListeners;
        synchronized (list) {
            if (!this.callListeners.contains(listener)) {
                this.callListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallChangeListener(CallChangeListener listener) {
        List<CallChangeListener> list = this.callListeners;
        synchronized (list) {
            this.callListeners.remove(listener);
        }
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    protected void fireCallPeerEvent(CallPeer sourceCallPeer, int eventID) {
        this.fireCallPeerEvent(sourceCallPeer, eventID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCallPeerEvent(CallPeer sourceCallPeer, int eventID, boolean delayed) {
        Iterator<CallChangeListener> listeners;
        CallPeerEvent event = new CallPeerEvent(sourceCallPeer, this, eventID, delayed);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a CallPeer event to " + this.callListeners.size() + " listeners. The event is: " + event));
        }
        List<CallChangeListener> list = this.callListeners;
        synchronized (list) {
            listeners = new ArrayList<CallChangeListener>(this.callListeners).iterator();
        }
        while (listeners.hasNext()) {
            CallChangeListener listener = listeners.next();
            if (eventID == 1) {
                listener.callPeerAdded(event);
                continue;
            }
            if (eventID != 2) continue;
            listener.callPeerRemoved(event);
        }
    }

    public String toString() {
        return "Call: id=" + this.getCallID() + " peers=" + this.getCallPeerCount();
    }

    protected void fireCallChangeEvent(String type, Object oldValue, Object newValue) {
        this.fireCallChangeEvent(type, oldValue, newValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCallChangeEvent(String type, Object oldValue, Object newValue, CallPeerChangeEvent cause) {
        CallChangeEvent event = new CallChangeEvent(this, type, oldValue, newValue, cause);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a CallChange event to " + this.callListeners.size() + " listeners. The event is: " + event));
        }
        CallChangeListener[] callChangeListenerArray = this.callListeners;
        synchronized (this.callListeners) {
            CallChangeListener[] listeners = this.callListeners.toArray(new CallChangeListener[this.callListeners.size()]);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            for (CallChangeListener listener : listeners) {
                listener.callStateChanged(event);
            }
            return;
        }
    }

    public CallState getCallState() {
        return this.callState;
    }

    protected void setCallState(CallState newState) {
        this.setCallState(newState, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCallState(CallState newState, CallPeerChangeEvent cause) {
        CallState oldState = this.getCallState();
        if (oldState != newState) {
            this.callState = newState;
            try {
                this.fireCallChangeEvent("CallState", oldState, this.callState, cause);
            }
            finally {
                if (CallState.CALL_ENDED.equals(this.getCallState())) {
                    this.setConference(null);
                }
            }
        }
    }

    public boolean isDefaultEncrypted() {
        return this.defaultEncryption;
    }

    public boolean isSipZrtpAttribute() {
        return this.sipZrtpAttribute;
    }

    public abstract Iterator<? extends CallPeer> getCallPeers();

    public abstract int getCallPeerCount();

    public abstract boolean isConferenceFocus();

    public abstract void addLocalUserSoundLevelListener(SoundLevelListener var1);

    public abstract void removeLocalUserSoundLevelListener(SoundLevelListener var1);

    protected CallConference createConference() {
        return new CallConference();
    }

    public CallConference getConference() {
        if (this.conference == null) {
            CallConference newValue = this.createConference();
            if (newValue == null) {
                throw new IllegalStateException(CONFERENCE);
            }
            this.setConference(newValue);
        }
        return this.conference;
    }

    public void setConference(CallConference conference) {
        if (this.conference != conference) {
            CallConference oldValue = this.conference;
            CallConference newValue = this.conference = conference;
            if (oldValue != null) {
                oldValue.removeCall(this);
            }
            if (newValue != null) {
                newValue.addCall(this);
            }
            this.firePropertyChange(CONFERENCE, (Object)oldValue, (Object)newValue);
        }
    }

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    protected abstract void firePropertyChange(String var1, Object var2, Object var3);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public boolean isAutoAnswer() {
        return this.isAutoAnswer;
    }

    public void setAutoAnswer(boolean autoAnswer) {
        this.isAutoAnswer = autoAnswer;
    }
}

