/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.TypingNotificationEvent;
import net.java.sip.communicator.service.protocol.event.TypingNotificationsListener;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractOperationSetTypingNotifications<T extends ProtocolProviderService>
implements OperationSetTypingNotifications {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetTypingNotifications.class);
    protected final T parentProvider;
    private final List<TypingNotificationsListener> typingNotificationsListeners = new ArrayList<TypingNotificationsListener>();

    protected AbstractOperationSetTypingNotifications(T parentProvider) {
        this.parentProvider = parentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTypingNotificationsListener(TypingNotificationsListener listener) {
        List<TypingNotificationsListener> list = this.typingNotificationsListeners;
        synchronized (list) {
            if (!this.typingNotificationsListeners.contains(listener)) {
                this.typingNotificationsListeners.add(listener);
            }
        }
    }

    protected void assertConnected() throws IllegalStateException {
        if (this.parentProvider == null) {
            throw new IllegalStateException("The provider must be non-null before being able to communicate.");
        }
        if (!this.parentProvider.isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTypingNotificationsEvent(Contact sourceContact, int evtCode) {
        TypingNotificationsListener[] listeners;
        List<TypingNotificationsListener> list = this.typingNotificationsListeners;
        synchronized (list) {
            listeners = this.typingNotificationsListeners.toArray(new TypingNotificationsListener[this.typingNotificationsListeners.size()]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a TypingNotificationEvent to " + listeners.length + " listeners. Contact " + sourceContact.getAddress() + " has now a typing status of " + evtCode));
        }
        TypingNotificationEvent evt = new TypingNotificationEvent(sourceContact, evtCode);
        for (TypingNotificationsListener listener : listeners) {
            listener.typingNotificationReceived(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTypingNotificationsDeliveryFailedEvent(Contact sourceContact, int evtCode) {
        TypingNotificationsListener[] listeners;
        List<TypingNotificationsListener> list = this.typingNotificationsListeners;
        synchronized (list) {
            listeners = this.typingNotificationsListeners.toArray(new TypingNotificationsListener[this.typingNotificationsListeners.size()]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a TypingNotificationEvent to " + listeners.length + " listeners for typingNotificationDeliveryFailed. Contact " + sourceContact.getAddress() + " has now a typing status of " + evtCode));
        }
        TypingNotificationEvent evt = new TypingNotificationEvent(sourceContact, evtCode);
        for (TypingNotificationsListener listener : listeners) {
            listener.typingNotificationDeliveryFailed(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTypingNotificationsListener(TypingNotificationsListener listener) {
        List<TypingNotificationsListener> list = this.typingNotificationsListeners;
        synchronized (list) {
            this.typingNotificationsListeners.remove(listener);
        }
    }
}

