/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.launchutils;

import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.launchutils.ArgDelegationPeer;

class ArgDelegator {
    private static final Logger logger = Logger.getLogger(ArgDelegator.class);
    private ArgDelegationPeer uriDelegationPeer = null;
    private List<String> recordedArgs = new LinkedList<String>();

    ArgDelegator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUri(String uriArg) {
        List<String> list = this.recordedArgs;
        synchronized (list) {
            if (this.uriDelegationPeer == null) {
                this.recordedArgs.add(uriArg);
                return;
            }
        }
        this.uriDelegationPeer.handleUri(uriArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegationPeer(ArgDelegationPeer delegationPeer) {
        List<String> list = this.recordedArgs;
        synchronized (list) {
            if (logger.isTraceEnabled()) {
                logger.trace("Someone set a delegationPeer. Will dispatch " + this.recordedArgs.size() + " args");
            }
            this.uriDelegationPeer = delegationPeer;
            for (String arg : this.recordedArgs) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Dispatching arg: " + arg);
                }
                this.uriDelegationPeer.handleUri(arg);
            }
            this.recordedArgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConcurrentInvocationRequest() {
        List<String> list = this.recordedArgs;
        synchronized (list) {
            if (this.uriDelegationPeer != null) {
                this.uriDelegationPeer.handleConcurrentInvocationRequest();
            }
        }
    }
}

