/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.text.MessageFormat;
import org.freedesktop.dbus.Gettext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UInt16
extends Number
implements Comparable<UInt16> {
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;
    private int value;

    public UInt16(int n) {
        if (n < 0 || n > 65535) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), n, 0, 65535));
        }
        this.value = n;
    }

    public UInt16(String string) {
        this(Integer.parseInt(string));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public boolean equals(Object object) {
        return object instanceof UInt16 && ((UInt16)object).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(UInt16 uInt16) {
        return this.value - uInt16.value;
    }

    public String toString() {
        return "" + this.value;
    }
}

