/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.multimap.impl.client.MultiMapAllPartitionRequest;
import com.hazelcast.multimap.impl.operations.MultiMapOperationFactory;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.Map;

public class ClearRequest
extends MultiMapAllPartitionRequest
implements RetryableRequest {
    public ClearRequest() {
    }

    public ClearRequest(String name) {
        super(name);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.CLEAR);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        int totalAffectedEntries = 0;
        for (Object affectedEntries : map.values()) {
            totalAffectedEntries += ((Integer)affectedEntries).intValue();
        }
        MultiMapService service = (MultiMapService)this.getService();
        service.publishMultiMapEvent(this.name, EntryEventType.CLEAR_ALL, totalAffectedEntries);
        return null;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "remove");
    }

    @Override
    public String getMethodName() {
        return "clear";
    }
}

