/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class PathToFileSet
extends Task {
    private File dir;
    private String name;
    private String pathRefId;
    private boolean ignoreNonRelative = false;
    private static FileUtils fileUtils = FileUtils.newFileUtils();

    public void setDir(File file) {
        this.dir = file;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPathRefId(String string) {
        this.pathRefId = string;
    }

    public void setIgnoreNonRelative(boolean bl) {
        this.ignoreNonRelative = bl;
    }

    public void execute() {
        if (this.dir == null) {
            throw new BuildException("missing dir");
        }
        if (this.name == null) {
            throw new BuildException("missing name");
        }
        if (this.pathRefId == null) {
            throw new BuildException("missing pathrefid");
        }
        if (!this.dir.isDirectory()) {
            throw new BuildException(this.dir.toString() + " is not a directory");
        }
        Object object = this.getProject().getReference(this.pathRefId);
        if (object == null) {
            throw new BuildException("Unknown reference " + this.pathRefId);
        }
        if (!(object instanceof Path)) {
            throw new BuildException(this.pathRefId + " is not a path");
        }
        String[] stringArray = ((Path)object).list();
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        fileSet.setDir(this.dir);
        String string = fileUtils.normalize(this.dir.getAbsolutePath()).getAbsolutePath() + File.separator;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(stringArray[n]);
            if (file.exists()) {
                String string2 = this.getRelativeName(string, file);
                if (string2 == null && !this.ignoreNonRelative) {
                    throw new BuildException(stringArray[n] + " is not relative to " + this.dir.getAbsolutePath());
                }
                if (string2 != null) {
                    fileSet.createInclude().setName(string2);
                    bl = true;
                }
            }
            ++n;
        }
        if (!bl) {
            fileSet.createInclude().setName("a:b:c:d//THis si &&& not a file  !!! ");
        }
        this.getProject().addReference(this.name, (Object)fileSet);
    }

    private String getRelativeName(String string, File file) {
        String string2 = fileUtils.normalize(file.getAbsolutePath()).getAbsolutePath();
        if (!string2.startsWith(string)) {
            return null;
        }
        return string2.substring(string.length());
    }
}

