/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class HashLoginService
extends MappedLoginService
implements PropertyUserStore.UserListener {
    private static final Logger LOG = Log.getLogger(HashLoginService.class);
    private PropertyUserStore _propertyUserStore;
    private String _config;
    private Resource _configResource;
    private Scanner _scanner;
    private int _refreshInterval = 0;

    public HashLoginService() {
    }

    public HashLoginService(String name) {
        this.setName(name);
    }

    public HashLoginService(String name, String config) {
        this.setName(name);
        this.setConfig(config);
    }

    public String getConfig() {
        return this._config;
    }

    public void getConfig(String config) {
        this._config = config;
    }

    public Resource getConfigResource() {
        return this._configResource;
    }

    public void setConfig(String config) {
        this._config = config;
    }

    public void setRefreshInterval(int msec) {
        this._refreshInterval = msec;
    }

    public int getRefreshInterval() {
        return this._refreshInterval;
    }

    @Override
    protected UserIdentity loadUser(String username) {
        return null;
    }

    @Override
    public void loadUsers() throws IOException {
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._propertyUserStore == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doStart: Starting new PropertyUserStore. PropertiesFile: " + this._config + " refreshInterval: " + this._refreshInterval, new Object[0]);
            }
            this._propertyUserStore = new PropertyUserStore();
            this._propertyUserStore.setRefreshInterval(this._refreshInterval);
            this._propertyUserStore.setConfig(this._config);
            this._propertyUserStore.registerUserListener(this);
            this._propertyUserStore.start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._scanner != null) {
            this._scanner.stop();
        }
        this._scanner = null;
    }

    @Override
    public void update(String userName, Credential credential, String[] roleArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("update: " + userName + " Roles: " + roleArray.length, new Object[0]);
        }
        this.putUser(userName, credential, roleArray);
    }

    @Override
    public void remove(String userName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove: " + userName, new Object[0]);
        }
        this.removeUser(userName);
    }
}

