/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.IParser;
import net.sf.jqql.packets.PacketHistory;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;
import net.sf.jqql.packets.in.AddFriendAuthResponseReplyPacket;
import net.sf.jqql.packets.in.AddFriendExReplyPacket;
import net.sf.jqql.packets.in.AdvancedSearchUserReplyPacket;
import net.sf.jqql.packets.in.AuthQuestionOpReplyPacket;
import net.sf.jqql.packets.in.ChangeStatusReplyPacket;
import net.sf.jqql.packets.in.ClusterCommandReplyPacket;
import net.sf.jqql.packets.in.DeleteFriendReplyPacket;
import net.sf.jqql.packets.in.DownloadGroupFriendReplyPacket;
import net.sf.jqql.packets.in.FriendChangeStatusPacket;
import net.sf.jqql.packets.in.FriendDataOpReplyPacket;
import net.sf.jqql.packets.in.FriendLevelOpReplyPacket;
import net.sf.jqql.packets.in.GetFriendListReplyPacket;
import net.sf.jqql.packets.in.GetKeyReplyPacket;
import net.sf.jqql.packets.in.GetTempClusterOnlineMemberReplyPacket;
import net.sf.jqql.packets.in.GetUserInfoReplyPacket;
import net.sf.jqql.packets.in.GroupDataOpReplyPacket;
import net.sf.jqql.packets.in.PrivacyDataOpReplyPacket;
import net.sf.jqql.packets.in.ReceiveIMPacket;
import net.sf.jqql.packets.in.RemoveSelfReplyPacket;
import net.sf.jqql.packets.in.SearchUserReplyPacket;
import net.sf.jqql.packets.in.SendIMReplyPacket;
import net.sf.jqql.packets.in.SendSMSReplyPacket;
import net.sf.jqql.packets.in.SignatureOpReplyPacket;
import net.sf.jqql.packets.in.SystemNotificationPacket;
import net.sf.jqql.packets.in.TempSessionOpReplyPacket;
import net.sf.jqql.packets.in.UnknownInPacket;
import net.sf.jqql.packets.in.UploadGroupFriendReplyPacket;
import net.sf.jqql.packets.in.UserPropertyOpReplyPacket;
import net.sf.jqql.packets.in.WeatherOpReplyPacket;
import net.sf.jqql.packets.in._08._08AuthInfoOpReplyPacket;
import net.sf.jqql.packets.in._08._08AuthorizeReplyPacket;
import net.sf.jqql.packets.in._08._08FirstLoginReplyPacket;
import net.sf.jqql.packets.in._08._08GetOnlineOpReplyPacket;
import net.sf.jqql.packets.in._08._08KeepAliveReplyPacket;
import net.sf.jqql.packets.in._08._08LoginKeyReplyPacket;
import net.sf.jqql.packets.in._08._08LoginReplyPacket;
import net.sf.jqql.packets.in._08._08LoginToken1ReplyPacket;
import net.sf.jqql.packets.in._08._08LoginToken2ReplyPacket;
import net.sf.jqql.packets.in._08._08ModifyInfoReplyPacket;
import net.sf.jqql.packets.in._08._08TouchLoginReplyPacket;
import net.sf.jqql.packets.out.AddFriendAuthResponsePacket;
import net.sf.jqql.packets.out.AddFriendExPacket;
import net.sf.jqql.packets.out.AdvancedSearchUserPacket;
import net.sf.jqql.packets.out.AuthQuestionOpPacket;
import net.sf.jqql.packets.out.ChangeStatusPacket;
import net.sf.jqql.packets.out.ClusterCommandPacket;
import net.sf.jqql.packets.out.DeleteFriendPacket;
import net.sf.jqql.packets.out.DownloadGroupFriendPacket;
import net.sf.jqql.packets.out.FriendDataOpPacket;
import net.sf.jqql.packets.out.FriendLevelOpPacket;
import net.sf.jqql.packets.out.GetFriendListPacket;
import net.sf.jqql.packets.out.GetUserInfoPacket;
import net.sf.jqql.packets.out.GroupDataOpPacket;
import net.sf.jqql.packets.out.LogoutPacket;
import net.sf.jqql.packets.out.PrivacyDataOpPacket;
import net.sf.jqql.packets.out.ReceiveIMReplyPacket;
import net.sf.jqql.packets.out.RemoveSelfPacket;
import net.sf.jqql.packets.out.SearchUserPacket;
import net.sf.jqql.packets.out.SendIMPacket;
import net.sf.jqql.packets.out.SendSMSPacket;
import net.sf.jqql.packets.out.TempSessionOpPacket;
import net.sf.jqql.packets.out.UnknownOutPacket;
import net.sf.jqql.packets.out.UploadGroupFriendPacket;
import net.sf.jqql.packets.out.UserPropertyOpPacket;
import net.sf.jqql.packets.out.WeatherOpPacket;
import net.sf.jqql.packets.out._08._08AuthInfoOpPacket;
import net.sf.jqql.packets.out._08._08AuthorizePacket;
import net.sf.jqql.packets.out._08._08FirstLoginPacket;
import net.sf.jqql.packets.out._08._08GetOnlineOpPacket;
import net.sf.jqql.packets.out._08._08KeepAlivePacket;
import net.sf.jqql.packets.out._08._08LoginKeyPacket;
import net.sf.jqql.packets.out._08._08LoginPacket;
import net.sf.jqql.packets.out._08._08LoginToken1Packet;
import net.sf.jqql.packets.out._08._08LoginToken2Packet;
import net.sf.jqql.packets.out._08._08ModifyInfoPacket;
import net.sf.jqql.packets.out._08._08SignatureOpPacket;
import net.sf.jqql.packets.out._08._08TouchLoginPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class _08BasicFamilyParser
implements IParser {
    static Log log = LogFactory.getLog(_08BasicFamilyParser.class);
    private int offset;
    private int length;
    private PacketHistory history = new PacketHistory();

    public boolean accept(ByteBuffer byteBuffer) {
        this.offset = byteBuffer.position();
        int n = byteBuffer.limit() - byteBuffer.position();
        if (n <= 0) {
            return false;
        }
        boolean bl = this.checkTcp(byteBuffer);
        if (!bl) {
            bl = this.checkUdp(byteBuffer);
        }
        return bl;
    }

    private boolean checkUdp(ByteBuffer byteBuffer) {
        if (byteBuffer.get(this.offset) == 2) {
            this.length = byteBuffer.limit() - byteBuffer.position();
            if (byteBuffer.get(this.offset + this.length - 1) == 3) {
                return true;
            }
        }
        return false;
    }

    private boolean checkTcp(ByteBuffer byteBuffer) {
        int n = byteBuffer.limit() - byteBuffer.position();
        if (n < 2) {
            return false;
        }
        this.length = byteBuffer.getChar(this.offset);
        if (this.length <= 0 || this.length > n) {
            return false;
        }
        return byteBuffer.get(this.offset + 2) == 2 && byteBuffer.get(this.offset + this.length - 1) == 3;
    }

    public int getLength(ByteBuffer byteBuffer) {
        return this.length;
    }

    public boolean isDuplicate(_08InPacket _08InPacket2) {
        return this.history.check(_08InPacket2, true);
    }

    private char getCommand(ByteBuffer byteBuffer, QQUser qQUser) {
        if (!qQUser.isUdp()) {
            return byteBuffer.getChar(this.offset + 5);
        }
        return byteBuffer.getChar(this.offset + 3);
    }

    public _08InPacket parseIncoming(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        try {
            switch (this.getCommand(byteBuffer, qQUser)) {
                case '\u0091': {
                    return new _08TouchLoginReplyPacket(byteBuffer, n, qQUser);
                }
                case 'b': {
                    return new _08LoginToken1ReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u00ba': {
                    return new _08LoginToken2ReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u00dd': {
                    return new _08LoginKeyReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u0018': {
                    return new _08FirstLoginReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u0002': {
                    return new _08KeepAliveReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u0004': {
                    return new _08ModifyInfoReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u00a7': {
                    return new AddFriendExReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u00b7': {
                    return new AuthQuestionOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u00ae': {
                    return new _08AuthInfoOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u0005': {
                    return new SearchUserReplyPacket(byteBuffer, n, qQUser);
                }
                case '\n': {
                    return new DeleteFriendReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u001c': {
                    return new RemoveSelfReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u000b': {
                    return new AddFriendAuthResponseReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u0006': {
                    return new GetUserInfoReplyPacket(byteBuffer, n, qQUser);
                }
                case '\r': {
                    return new ChangeStatusReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u0016': {
                    return new SendIMReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u0017': {
                    return new ReceiveIMPacket(byteBuffer, n, qQUser);
                }
                case '\"': {
                    return new _08LoginReplyPacket(byteBuffer, n, qQUser);
                }
                case '&': {
                    return new GetFriendListReplyPacket(byteBuffer, n, qQUser);
                }
                case '\'': {
                    log.debug((Object)"\u83b7\u5f97\u5728\u7ebf\u597d\u53cb\u5217\u8868\u5305\u5df2\u7ecf\u88ab\u56de\u590d\uff01");
                    return new _08GetOnlineOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u0080': {
                    return new SystemNotificationPacket(byteBuffer, n, qQUser);
                }
                case '\u0081': {
                    return new FriendChangeStatusPacket(byteBuffer, n, qQUser);
                }
                case '=': {
                    return new UploadGroupFriendReplyPacket(byteBuffer, n, qQUser);
                }
                case 'X': {
                    return new DownloadGroupFriendReplyPacket(byteBuffer, n, qQUser);
                }
                case '<': {
                    return new GroupDataOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '>': {
                    return new FriendDataOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '0': {
                    return new ClusterCommandReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u001d': {
                    return new GetKeyReplyPacket(byteBuffer, n, qQUser);
                }
                case 'a': {
                    return new AdvancedSearchUserReplyPacket(byteBuffer, n, qQUser);
                }
                case '_': {
                    return new GetTempClusterOnlineMemberReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u00a8': {
                    return new _08AuthorizeReplyPacket(byteBuffer, n, qQUser);
                }
                case 'g': {
                    return new SignatureOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u00a6': {
                    return new WeatherOpReplyPacket(byteBuffer, n, qQUser);
                }
                case 'e': {
                    return new UserPropertyOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '\\': {
                    return new FriendLevelOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '-': {
                    return new SendSMSReplyPacket(byteBuffer, n, qQUser);
                }
                case '\u00e1': {
                    return new TempSessionOpReplyPacket(byteBuffer, n, qQUser);
                }
                case '^': {
                    return new PrivacyDataOpReplyPacket(byteBuffer, n, qQUser);
                }
            }
            return new UnknownInPacket(byteBuffer, n, qQUser);
        }
        catch (PacketParseException packetParseException) {
            byteBuffer.position(this.offset);
            return new UnknownInPacket(byteBuffer, n, qQUser);
        }
    }

    public _08OutPacket parseOutcoming(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        try {
            switch (this.getCommand(byteBuffer, qQUser)) {
                case '\u0091': {
                    return new _08TouchLoginPacket(byteBuffer, n, qQUser);
                }
                case 'b': {
                    return new _08LoginToken1Packet(byteBuffer, n, qQUser);
                }
                case '\u00ba': {
                    return new _08LoginToken2Packet(byteBuffer, n, qQUser);
                }
                case '\u00dd': {
                    System.out.println("Login Key \u5df2\u7ecf\u88ab\u53d1\u9001");
                    return new _08LoginKeyPacket(byteBuffer, n, qQUser);
                }
                case '\u0002': {
                    return new _08KeepAlivePacket(byteBuffer, n, qQUser);
                }
                case '\u0004': {
                    return new _08ModifyInfoPacket(byteBuffer, n, qQUser);
                }
                case '\u0005': {
                    return new SearchUserPacket(byteBuffer, n, qQUser);
                }
                case '\u00a7': {
                    return new AddFriendExPacket(byteBuffer, n, qQUser);
                }
                case '\u00ae': {
                    System.out.println("auth infp op \u5305\u5df2\u7ecf\u88ab\u53d1\u9001");
                    return new _08AuthInfoOpPacket(byteBuffer, n, qQUser);
                }
                case '\u00b7': {
                    return new AuthQuestionOpPacket(byteBuffer, n, qQUser);
                }
                case '\n': {
                    return new DeleteFriendPacket(byteBuffer, n, qQUser);
                }
                case '\u001c': {
                    return new RemoveSelfPacket(byteBuffer, n, qQUser);
                }
                case '\u000b': {
                    return new AddFriendAuthResponsePacket(byteBuffer, n, qQUser);
                }
                case '\u0006': {
                    return new GetUserInfoPacket(byteBuffer, n, qQUser);
                }
                case '\r': {
                    return new ChangeStatusPacket(byteBuffer, n, qQUser);
                }
                case '\u0016': {
                    return new SendIMPacket(byteBuffer, n, qQUser);
                }
                case '\u0017': {
                    return new ReceiveIMReplyPacket(byteBuffer, n, qQUser);
                }
                case '\"': {
                    return new _08LoginPacket(byteBuffer, n, qQUser);
                }
                case '\u0018': {
                    return new _08FirstLoginPacket(byteBuffer, n, qQUser);
                }
                case '&': {
                    return new GetFriendListPacket(byteBuffer, n, qQUser);
                }
                case '\'': {
                    return new _08GetOnlineOpPacket(byteBuffer, n, qQUser);
                }
                case '=': {
                    return new UploadGroupFriendPacket(byteBuffer, n, qQUser);
                }
                case 'X': {
                    return new DownloadGroupFriendPacket(byteBuffer, n, qQUser);
                }
                case '<': {
                    return new GroupDataOpPacket(byteBuffer, n, qQUser);
                }
                case '>': {
                    return new FriendDataOpPacket(byteBuffer, n, qQUser);
                }
                case 'a': {
                    return new AdvancedSearchUserPacket(byteBuffer, n, qQUser);
                }
                case '0': {
                    return new ClusterCommandPacket(byteBuffer, n, qQUser);
                }
                case '\u0001': {
                    return new LogoutPacket(byteBuffer, n, qQUser);
                }
                case '\u00a8': {
                    return new _08AuthorizePacket(byteBuffer, n, qQUser);
                }
                case 'g': {
                    return new _08SignatureOpPacket(byteBuffer, n, qQUser);
                }
                case '\u00a6': {
                    return new WeatherOpPacket(byteBuffer, n, qQUser);
                }
                case 'e': {
                    return new UserPropertyOpPacket(byteBuffer, n, qQUser);
                }
                case '\\': {
                    return new FriendLevelOpPacket(byteBuffer, n, qQUser);
                }
                case '-': {
                    return new SendSMSPacket(byteBuffer, n, qQUser);
                }
                case '\u00e1': {
                    return new TempSessionOpPacket(byteBuffer, n, qQUser);
                }
                case '^': {
                    return new PrivacyDataOpPacket(byteBuffer, n, qQUser);
                }
            }
            return new UnknownOutPacket(byteBuffer, n, qQUser);
        }
        catch (PacketParseException packetParseException) {
            byteBuffer.position(this.offset);
            return new UnknownOutPacket(byteBuffer, n, qQUser);
        }
    }

    public boolean isDuplicatedNeedReply(_08InPacket _08InPacket2) {
        return _08InPacket2.getCommand() == '\u0017';
    }

    public int relocate(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        if (byteBuffer.remaining() < 2) {
            return n;
        }
        char c = byteBuffer.getChar(n);
        if (c <= '\u0000' || n + c > byteBuffer.limit()) {
            return n;
        }
        return n + c;
    }

    public PacketHistory getHistory() {
        return this.history;
    }
}

