/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql;

import net.sf.jqql.QQClient;
import net.sf.jqql.QQPort;
import net.sf.jqql.events.IPacketListener;
import net.sf.jqql.events.PacketEvent;
import net.sf.jqql.packets.ErrorPacket;
import net.sf.jqql.packets._08InPacket;

class ProcessorRouter {
    private IPacketListener[] listeners;
    private int count;
    private QQClient client;

    public ProcessorRouter(QQClient qQClient, int n) {
        this.client = qQClient;
        this.listeners = new IPacketListener[n];
        this.count = 0;
    }

    public void installProcessor(IPacketListener iPacketListener) {
        this.listeners[this.count++] = iPacketListener;
    }

    public void packetArrived(PacketEvent packetEvent) {
        _08InPacket _08InPacket2 = (_08InPacket)packetEvent.getSource();
        try {
            for (int i = 0; i < this.count; ++i) {
                if (!this.listeners[i].accept(_08InPacket2)) continue;
                this.listeners[i].packetArrived(packetEvent);
                return;
            }
        }
        catch (Throwable throwable) {
            ErrorPacket errorPacket = new ErrorPacket(4, this.client.getUser());
            errorPacket.errorMessage = this.client.generateCrashReport(throwable, _08InPacket2);
            errorPacket.setFamily(1);
            errorPacket.connectionId = QQPort.MAIN.name;
            this.client.addIncomingPacket(errorPacket, errorPacket.connectionId);
        }
    }
}

