/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.ims;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.ims.SecurityAgreeHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;

public abstract class SecurityAgree
extends ParametersHeader {
    private String secMechanism;

    public SecurityAgree(String string) {
        super(string);
        this.parameters.setSeparator(";");
    }

    public SecurityAgree() {
        this.parameters.setSeparator(";");
    }

    public void setParameter(String string, String string2) throws ParseException {
        if (string2 == null) {
            throw new NullPointerException("null value");
        }
        NameValue nameValue = this.parameters.getNameValue(string.toLowerCase());
        if (nameValue == null) {
            nameValue = new NameValue(string, string2);
            if (string.equalsIgnoreCase("d-ver")) {
                nameValue.setQuotedValue();
                if (string2.startsWith("\"")) {
                    throw new ParseException(string2 + " : Unexpected DOUBLE_QUOTE", 0);
                }
            }
            super.setParameter(nameValue);
        } else {
            nameValue.setValue(string2);
        }
    }

    public String encodeBody() {
        return this.secMechanism + ";" + " " + this.parameters.encode();
    }

    public void setSecurityMechanism(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityAgree, setSecurityMechanism(), the sec-mechanism parameter is null");
        }
        this.secMechanism = string;
    }

    public void setEncryptionAlgorithm(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityClient, setEncryptionAlgorithm(), the encryption-algorithm parameter is null");
        }
        this.setParameter("ealg", string);
    }

    public void setAlgorithm(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityClient, setAlgorithm(), the algorithm parameter is null");
        }
        this.setParameter("alg", string);
    }

    public void setProtocol(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityClient, setProtocol(), the protocol parameter is null");
        }
        this.setParameter("prot", string);
    }

    public void setMode(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SecurityClient, setMode(), the mode parameter is null");
        }
        this.setParameter("mod", string);
    }

    public void setSPIClient(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setSPIClient(), the spi-c parameter is <0");
        }
        this.setParameter("spi-c", n);
    }

    public void setSPIServer(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setSPIServer(), the spi-s parameter is <0");
        }
        this.setParameter("spi-s", n);
    }

    public void setPortClient(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setPortClient(), the port-c parameter is <0");
        }
        this.setParameter("port-c", n);
    }

    public void setPortServer(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setPortServer(), the port-s parameter is <0");
        }
        this.setParameter("port-s", n);
    }

    public void setPreference(float f) throws InvalidArgumentException {
        if (f < 0.0f) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SecurityClient, setPreference(), the preference (q) parameter is <0");
        }
        this.setParameter("q", f);
    }

    public String getSecurityMechanism() {
        return this.secMechanism;
    }

    public String getEncryptionAlgorithm() {
        return this.getParameter("ealg");
    }

    public String getAlgorithm() {
        return this.getParameter("alg");
    }

    public String getProtocol() {
        return this.getParameter("prot");
    }

    public String getMode() {
        return this.getParameter("mod");
    }

    public int getSPIClient() {
        return Integer.parseInt(this.getParameter("spi-c"));
    }

    public int getSPIServer() {
        return Integer.parseInt(this.getParameter("spi-s"));
    }

    public int getPortClient() {
        return Integer.parseInt(this.getParameter("port-c"));
    }

    public int getPortServer() {
        return Integer.parseInt(this.getParameter("port-s"));
    }

    public float getPreference() {
        return Float.parseFloat(this.getParameter("q"));
    }

    public boolean equals(Object object) {
        if (object instanceof SecurityAgreeHeader) {
            SecurityAgreeHeader securityAgreeHeader = (SecurityAgreeHeader)object;
            return this.getSecurityMechanism().equals(securityAgreeHeader.getSecurityMechanism()) && this.equalParameters(securityAgreeHeader);
        }
        return false;
    }

    public Object clone() {
        SecurityAgree securityAgree = (SecurityAgree)super.clone();
        if (this.secMechanism != null) {
            securityAgree.secMechanism = this.secMechanism;
        }
        return securityAgree;
    }
}

