/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.ContactList;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Address;
import javax.sip.header.ContactHeader;

public final class Contact
extends AddressParametersHeader
implements ContactHeader {
    private static final long serialVersionUID = 1677294871695706288L;
    public static final String ACTION = "action";
    public static final String PROXY = "proxy";
    public static final String REDIRECT = "redirect";
    public static final String EXPIRES = "expires";
    public static final String Q = "q";
    private ContactList contactList;
    protected boolean wildCardFlag;

    public Contact() {
        super("Contact");
    }

    public void setParameter(String string, String string2) throws ParseException {
        NameValue nameValue = this.parameters.getNameValue(string);
        if (nameValue != null) {
            nameValue.setValue(string2);
        } else {
            nameValue = new NameValue(string, string2);
            if (string.equalsIgnoreCase("methods")) {
                nameValue.setQuotedValue();
            }
            this.parameters.set(nameValue);
        }
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer stringBuffer) {
        if (this.wildCardFlag) {
            stringBuffer.append('*');
        } else {
            if (this.address.getAddressType() == 1) {
                this.address.encode(stringBuffer);
            } else {
                stringBuffer.append('<');
                this.address.encode(stringBuffer);
                stringBuffer.append('>');
            }
            if (!this.parameters.isEmpty()) {
                stringBuffer.append(";");
                this.parameters.encode(stringBuffer);
            }
        }
        return stringBuffer;
    }

    public ContactList getContactList() {
        return this.contactList;
    }

    public boolean getWildCardFlag() {
        return this.wildCardFlag;
    }

    public Address getAddress() {
        return this.address;
    }

    public NameValueList getContactParms() {
        return this.parameters;
    }

    public int getExpires() {
        return this.getParameterAsInt(EXPIRES);
    }

    public void setExpires(int n) {
        Integer n2 = new Integer(n);
        this.parameters.set(EXPIRES, n2);
    }

    public float getQValue() {
        return this.getParameterAsFloat(Q);
    }

    public void setContactList(ContactList contactList) {
        this.contactList = contactList;
    }

    public void setWildCardFlag(boolean bl) {
        this.wildCardFlag = true;
        this.address = new AddressImpl();
        this.address.setWildCardFlag();
    }

    public void setAddress(Address address) {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        this.address = (AddressImpl)address;
        this.wildCardFlag = false;
    }

    public void setQValue(float f) throws InvalidArgumentException {
        if (f != -1.0f && (f < 0.0f || f > 1.0f)) {
            throw new InvalidArgumentException("JAIN-SIP Exception, Contact, setQValue(), the qValue is not between 0 and 1");
        }
        this.parameters.set(Q, new Float(f));
    }

    public Object clone() {
        Contact contact = (Contact)super.clone();
        if (this.contactList != null) {
            contact.contactList = (ContactList)this.contactList.clone();
        }
        return contact;
    }

    public void setWildCard() {
        this.setWildCardFlag(true);
    }

    public boolean isWildCard() {
        return this.address.isWildcard();
    }

    public boolean equals(Object object) {
        return object instanceof ContactHeader && super.equals(object);
    }

    public void removeSipInstanceParam() {
        if (this.parameters != null) {
            this.parameters.delete("+sip.instance");
        }
    }

    public String getSipInstanceParam() {
        return (String)this.parameters.getValue("+sip.instance");
    }

    public void setSipInstanceParam(String string) {
        this.parameters.set("+sip.instance", string);
    }

    public void removePubGruuParam() {
        if (this.parameters != null) {
            this.parameters.delete("pub-gruu");
        }
    }

    public String getPubGruuParam() {
        return (String)this.parameters.getValue("pub-gruu");
    }

    public void setPubGruuParam(String string) {
        this.parameters.set("pub-gruu", string);
    }

    public void removeTempGruuParam() {
        if (this.parameters != null) {
            this.parameters.delete("temp-gruu");
        }
    }

    public String getTempGruuParam() {
        return (String)this.parameters.getValue("temp-gruu");
    }

    public void setTempGruuParam(String string) {
        this.parameters.set("temp-gruu", string);
    }
}

