/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;

public class NameValue
extends GenericObject {
    protected boolean isQuotedString;
    protected final boolean isFlagParameter;
    protected String separator;
    protected String quotes;
    protected String name;
    protected Object value;

    public NameValue() {
        this.name = null;
        this.value = "";
        this.separator = "=";
        this.quotes = "";
        this.isFlagParameter = false;
    }

    public NameValue(String string, Object object, boolean bl) {
        this.name = string;
        this.value = object;
        this.separator = "=";
        this.quotes = "";
        this.isFlagParameter = bl;
    }

    public NameValue(String string, Object object) {
        this(string, object, false);
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void setQuotedValue() {
        this.isQuotedString = true;
        this.quotes = "\"";
    }

    public boolean isValueQuoted() {
        return this.isQuotedString;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.isFlagParameter ? "" : this.value;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public String encode() {
        return this.encode(new StringBuffer()).toString();
    }

    public StringBuffer encode(StringBuffer stringBuffer) {
        if (this.name != null && this.value != null && !this.isFlagParameter) {
            if (GenericObject.isMySubclass(this.value.getClass())) {
                GenericObject genericObject = (GenericObject)this.value;
                stringBuffer.append(this.name).append(this.separator).append(this.quotes);
                genericObject.encode(stringBuffer);
                stringBuffer.append(this.quotes);
                return stringBuffer;
            }
            if (GenericObjectList.isMySubclass(this.value.getClass())) {
                GenericObjectList genericObjectList = (GenericObjectList)this.value;
                stringBuffer.append(this.name).append(this.separator).append(genericObjectList.encode());
                return stringBuffer;
            }
            if (this.value.toString().length() == 0) {
                if (this.isQuotedString) {
                    stringBuffer.append(this.name).append(this.separator).append(this.quotes).append(this.quotes);
                    return stringBuffer;
                }
                stringBuffer.append(this.name);
                return stringBuffer;
            }
            stringBuffer.append(this.name).append(this.separator).append(this.quotes).append(this.value.toString()).append(this.quotes);
            return stringBuffer;
        }
        if (this.name == null && this.value != null) {
            if (GenericObject.isMySubclass(this.value.getClass())) {
                GenericObject genericObject = (GenericObject)this.value;
                genericObject.encode(stringBuffer);
                return stringBuffer;
            }
            if (GenericObjectList.isMySubclass(this.value.getClass())) {
                GenericObjectList genericObjectList = (GenericObjectList)this.value;
                stringBuffer.append(genericObjectList.encode());
                return stringBuffer;
            }
            stringBuffer.append(this.quotes).append(this.value.toString()).append(this.quotes);
            return stringBuffer;
        }
        if (this.name != null && (this.value == null || this.isFlagParameter)) {
            stringBuffer.append(this.name);
            return stringBuffer;
        }
        return stringBuffer;
    }

    public Object clone() {
        NameValue nameValue = (NameValue)super.clone();
        if (this.value != null) {
            nameValue.value = NameValue.makeClone(this.value);
        }
        return nameValue;
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        NameValue nameValue = (NameValue)object;
        if (this == nameValue) {
            return true;
        }
        if (this.name == null && nameValue.name != null || this.name != null && nameValue.name == null) {
            return false;
        }
        if (this.name != null && nameValue.name != null && this.name.compareToIgnoreCase(nameValue.name) != 0) {
            return false;
        }
        if (this.value != null && nameValue.value == null || this.value == null && nameValue.value != null) {
            return false;
        }
        if (this.value == nameValue.value) {
            return true;
        }
        if (this.value instanceof String) {
            if (this.isQuotedString) {
                return this.value.equals(nameValue.value);
            }
            String string = (String)this.value;
            String string2 = (String)nameValue.value;
            return string.compareToIgnoreCase(string2) == 0;
        }
        return this.value.equals(nameValue.value);
    }
}

