/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.support;

import java.util.ArrayList;
import java.util.List;

public class MessageElement {
    public static final int NULL = -2;
    public static final int ROOT = -1;
    public static final int TEXT = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int COLOUR_INDEX = 3;
    public static final int UNDERLINE = 4;
    public static final int FONT = 5;
    public static final int FADE = 6;
    public static final int ALT = 7;
    public static final int COLOUR_ABS = 8;
    public static final int COLOUR_NAME = 9;
    protected int type;
    protected List<MessageElement> children;
    protected String text;
    protected int colour;
    static final String[] COLOUR_INDEXES = new String[]{"black", "blue", "cyan", "pink", "green", "gray", "purple", "orange", "red", "brown", "yellow"};

    protected MessageElement(int t) {
        this.type = t;
        this.children = new ArrayList<MessageElement>();
    }

    protected MessageElement(int t, String body) {
        this(t);
        switch (t) {
            case 0: {
                this.text = body;
                break;
            }
        }
    }

    protected MessageElement(int t, int num) {
        this(t);
        switch (t) {
            case 9: {
                this.colour = num;
            }
        }
    }

    static int whichColourName(String n) {
        for (int i = 0; i < COLOUR_INDEXES.length; ++i) {
            if (!n.equals(COLOUR_INDEXES[i])) continue;
            return i;
        }
        return -1;
    }

    boolean colourEquals(int i) {
        return this.colour == i;
    }

    void addChild(MessageElement s) {
        this.children.add(s);
    }

    public String toText() {
        StringBuffer sb = new StringBuffer();
        this.toText(sb);
        return sb.toString();
    }

    private void toText(StringBuffer sb) {
        if (this.type == 0) {
            sb.append(this.text);
        }
        for (MessageElement sc : this.children) {
            sc.toText(sb);
        }
    }
}

