/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.AbstractInfoCmd;

public class MetaShortInfoCmd
extends AbstractInfoCmd {
    private static final int NDX_NICKNAME = 0;
    private static final int NDX_FNAME = 1;
    private static final int NDX_LNAME = 2;
    private static final int NDX_EMAIL = 3;
    private String[] s;
    private byte authorizationFlag;
    private byte gender;

    public MetaShortInfoCmd(SnacPacket packet) {
        super(packet);
    }

    public MetaShortInfoCmd(int uin, int id, String nickname, String fname, String lname, String email, byte authorizationFlag, byte gender) {
        super(uin, AbstractIcqCmd.CMD_META_SHORT_INFO_CMD, id);
        this.s = new String[4];
        this.s[0] = nickname;
        this.s[1] = fname;
        this.s[2] = lname;
        this.s[3] = email;
        this.authorizationFlag = authorizationFlag;
        this.gender = gender;
    }

    protected void readInfo(InputStream is) throws IOException {
        this.s = new String[4];
        for (int i = 0; i < this.s.length; ++i) {
            this.s[i] = LEBinaryTools.readUShortLengthString(is);
            if (this.s[i] == null) break;
        }
        this.authorizationFlag = (byte)is.read();
        is.read();
        this.gender = (byte)is.read();
    }

    protected void writeInfo(OutputStream out) throws IOException {
        for (String value : this.s) {
            LEBinaryTools.writeUShortLengthString(out, value);
        }
        LEBinaryTools.writeUByte(out, this.authorizationFlag);
        LEBinaryTools.writeUByte(out, 0);
        LEBinaryTools.writeUByte(out, this.gender);
    }

    public String getNickname() {
        if (this.s == null) {
            return null;
        }
        return this.s[0];
    }

    public String getFirstName() {
        if (this.s == null) {
            return null;
        }
        return this.s[1];
    }

    public String getLastName() {
        if (this.s == null) {
            return null;
        }
        return this.s[2];
    }

    public String getEmail() {
        if (this.s == null) {
            return null;
        }
        return this.s[3];
    }

    public byte getAuthorizationFlag() {
        return this.authorizationFlag;
    }

    public byte getGender() {
        return this.gender;
    }

    public String toString() {
        return "MetaShortInfoCmd: nick=" + this.getNickname() + " firstname=" + this.getFirstName() + " lastname=" + this.getLastName() + " email=" + this.getEmail() + " authorizationFlag=" + this.getAuthorizationFlag() + " gender=" + this.getGender() + " in: " + super.toString();
    }
}

